/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.processor;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.UriMapping;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.ws.rs.BeanParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Internal
public class JaxRsTypeElementVisitor
implements TypeElementVisitor<Object, Object> {
    public static final int POSITION = 200;
    private ClassElement currentClassElement;

    public int getOrder() {
        return 200;
    }

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public Set<String> getSupportedAnnotationNames() {
        return Collections.singleton("javax.ws.rs.*");
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        this.currentClassElement = element;
        if (element.hasAnnotation(Path.class) && !element.isAbstract()) {
            element.stringValue(Path.class).ifPresent(p -> {
                element.annotate(Controller.class, builder -> builder.value(p));
                element.annotate(UriMapping.class, builder -> builder.value(p));
            });
        }
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        if (element.hasStereotype(HttpMethod.class)) {
            ParameterElement[] parameters;
            if (this.currentClassElement != null && !this.currentClassElement.hasAnnotation(Controller.class) && !this.currentClassElement.isAbstract()) {
                this.currentClassElement.annotate(Controller.class);
            }
            for (ParameterElement parameter : parameters = element.getParameters()) {
                List<Class<? extends Annotation>> unsupported = this.getUnsupportedParameterAnnotations();
                for (Class<? extends Annotation> annType : unsupported) {
                    if (!parameter.hasAnnotation(annType)) continue;
                    context.fail("Unsupported JAX-RS annotation used on method: " + annType.getName(), (Element)parameter);
                }
            }
        }
    }

    private List<Class<? extends Annotation>> getUnsupportedParameterAnnotations() {
        return Arrays.asList(MatrixParam.class, BeanParam.class);
    }

    public void start(VisitorContext visitorContext) {
        visitorContext.getClassElement(SecurityContext.class).ifPresent(securityContext -> securityContext.annotate(Bindable.class));
        visitorContext.getClassElement(Context.class).ifPresent(ann -> ann.annotate(Bindable.class));
    }
}

