/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.processor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.annotation.CustomHttpMethod;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Head;
import io.micronaut.http.annotation.Options;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Put;
import io.micronaut.http.annotation.Trace;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

@Internal
public class HttpMethodMapper
implements NamedAnnotationMapper {
    @NonNull
    public String getName() {
        return "jakarta.ws.rs.HttpMethod";
    }

    public List<AnnotationValue<?>> map(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        String name = annotation.stringValue().orElse(null);
        if (name != null) {
            name = name.toUpperCase(Locale.ENGLISH);
            HttpMethod httpMethod = HttpMethod.parse((String)name);
            AnnotationValueBuilder builder = switch (httpMethod) {
                default -> throw new IncompatibleClassChangeError();
                case HttpMethod.GET -> AnnotationValue.builder(Get.class);
                case HttpMethod.POST -> AnnotationValue.builder(Post.class);
                case HttpMethod.PUT -> AnnotationValue.builder(Put.class);
                case HttpMethod.PATCH -> AnnotationValue.builder(Patch.class);
                case HttpMethod.DELETE -> AnnotationValue.builder(Delete.class);
                case HttpMethod.TRACE -> AnnotationValue.builder(Trace.class);
                case HttpMethod.OPTIONS -> AnnotationValue.builder(Options.class);
                case HttpMethod.HEAD -> AnnotationValue.builder(Head.class);
                case HttpMethod.CUSTOM, HttpMethod.CONNECT -> AnnotationValue.builder(CustomHttpMethod.class).member("method", name);
            };
            return Collections.singletonList(builder.value("/").build());
        }
        return Collections.emptyList();
    }
}

