/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.processor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.annotation.UriMapping;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.Encoded;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.HttpMethod;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@Internal
public class JaxRsTypeElementVisitor
implements TypeElementVisitor<Object, Object> {
    public static final int POSITION = 200;
    private static final Class<?>[] BINDABLE_TYPES = new Class[]{Context.class, SecurityContext.class, UriInfo.class};
    private ClassElement currentClassElement;
    private final List<Class<? extends Annotation>> JAX_RS_BINDING_ANNOTATIONS = List.of(HeaderParam.class, QueryParam.class, FormParam.class, MatrixParam.class, PathParam.class, CookieParam.class, BeanParam.class);
    private final List<String> JAX_RS_BINDING_TYPES = List.of(HttpHeaders.class.getName(), Cookie.class.getName(), SecurityContext.class.getName(), UriInfo.class.getName(), "jakarta.servlet.ServletContext", "jakarta.servlet.ServletRequest", "jakarta.servlet.http.HttpServletRequest", "jakarta.servlet.ServletResponse", "jakarta.servlet.http.HttpServletResponse", "jakarta.servlet.ServletConfig");

    public int getOrder() {
        return 200;
    }

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public Set<String> getSupportedAnnotationNames() {
        return Collections.singleton("jakarta.ws.rs.*");
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        if (element.hasStereotype(Provider.class)) {
            if (element.isEnum()) {
                return;
            }
            element.annotate(Singleton.class);
            element.annotate(Named.class);
            return;
        }
        this.currentClassElement = element;
        if (element.hasAnnotation(Path.class) && !element.isAbstract()) {
            element.stringValue(Path.class).ifPresent(p -> {
                element.annotate(Controller.class, builder -> builder.value(p));
                element.annotate(UriMapping.class, builder -> builder.value(p));
            });
        }
    }

    public void visitMethod(MethodElement element, VisitorContext context) {
        if (element.hasStereotype(HttpMethod.class)) {
            ParameterElement[] parameters;
            if (this.currentClassElement != null && !this.currentClassElement.hasAnnotation(Controller.class) && !this.currentClassElement.isAbstract()) {
                this.currentClassElement.annotate(Controller.class);
            }
            if (!(this.currentClassElement != null && this.currentClassElement.hasAnnotation(Produces.class) || element.hasAnnotation(Produces.class))) {
                element.annotate(Produces.class, b -> b.values(new String[]{"*/*"}));
            }
            if (!(this.currentClassElement != null && this.currentClassElement.hasAnnotation(Consumes.class) || element.hasAnnotation(Consumes.class))) {
                element.annotate(Consumes.class, b -> b.values(new String[]{"*/*"}));
            }
            for (ParameterElement parameter : parameters = element.getParameters()) {
                List<Class<? extends Annotation>> unsupported = this.getUnsupportedParameterAnnotations();
                for (Class<? extends Annotation> annType : unsupported) {
                    if (!parameter.hasAnnotation(annType)) continue;
                    context.fail("Unsupported JAX-RS annotation used on method: " + annType.getName(), (Element)parameter);
                }
                JaxRsTypeElementVisitor.visitParamOrField((TypedElement)parameter);
                String parameterTypeName = parameter.getType().getName();
                if (!this.JAX_RS_BINDING_ANNOTATIONS.stream().noneMatch(arg_0 -> ((ParameterElement)parameter).hasAnnotation(arg_0)) || !this.JAX_RS_BINDING_TYPES.stream().noneMatch(cl -> cl.equals(parameterTypeName))) continue;
                parameter.annotate(Body.class);
                parameter.annotate(Nullable.class);
            }
        }
    }

    public void visitField(FieldElement element, VisitorContext context) {
        JaxRsTypeElementVisitor.visitParamOrField((TypedElement)element);
        if (element.hasAnnotation(HeaderParam.class) || element.hasAnnotation(QueryParam.class) || element.hasAnnotation(FormParam.class) || element.hasAnnotation(MatrixParam.class) || element.hasAnnotation(PathParam.class) || element.hasAnnotation(CookieParam.class) || element.hasAnnotation(BeanParam.class)) {
            context.fail("Request scoped bean parameters are currently not supported", (Element)element);
        }
    }

    private static void visitParamOrField(TypedElement parameter) {
        JaxRsTypeElementVisitor.mapParam(parameter, HeaderParam.class, Header.class);
        JaxRsTypeElementVisitor.mapParam(parameter, FormParam.class, Body.class);
        JaxRsTypeElementVisitor.mapParam(parameter, QueryParam.class, QueryValue.class);
        JaxRsTypeElementVisitor.mapParam(parameter, CookieParam.class, CookieValue.class);
        JaxRsTypeElementVisitor.mapParam(parameter, PathParam.class, PathVariable.class);
    }

    private static <P extends Annotation> void mapParam(TypedElement parameter, Class<P> jakartaAnnotation, Class<? extends Annotation> mnAnnotation) {
        AnnotationValue ann = parameter.getAnnotation(jakartaAnnotation);
        if (ann != null) {
            parameter.annotate(mnAnnotation, builder -> {
                ann.stringValue().ifPresent(arg_0 -> ((AnnotationValueBuilder)builder).value(arg_0));
                if (!parameter.isNonNull()) {
                    if (parameter.isPrimitive()) {
                        if (parameter.getType().isAssignable(Boolean.TYPE)) {
                            builder.member("defaultValue", "false");
                        } else {
                            builder.member("defaultValue", "0");
                        }
                    } else {
                        parameter.annotate(Nullable.class);
                    }
                }
            });
        }
    }

    private List<Class<? extends Annotation>> getUnsupportedParameterAnnotations() {
        return Arrays.asList(MatrixParam.class, BeanParam.class, Encoded.class);
    }

    public void start(VisitorContext visitorContext) {
        for (Class<?> type : BINDABLE_TYPES) {
            visitorContext.getClassElement(type).ifPresent(bindable -> bindable.annotate(Bindable.class));
        }
    }
}

