/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.processor;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.annotation.Produces;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Internal
public class ProducesMapper
implements NamedAnnotationMapper {
    private static final String[] JAX_RS_DEFAULT_VALUE = new String[]{"*/*"};

    @NonNull
    public String getName() {
        return "jakarta.ws.rs.Produces";
    }

    public List<AnnotationValue<?>> map(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        AnnotationValueBuilder builder = AnnotationValue.builder(Produces.class);
        if (annotation.stringValues().length > 0) {
            builder.values(ProducesMapper.splitMediaTypes(annotation.stringValues()));
        } else {
            builder.values(JAX_RS_DEFAULT_VALUE);
        }
        return Collections.singletonList(builder.build());
    }

    static String[] splitMediaTypes(String[] mediaTypes) {
        return (String[])Arrays.stream(mediaTypes).flatMap(t -> Arrays.stream(t.split(","))).map(String::trim).toArray(String[]::new);
    }
}

