/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.runtime.core;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.conventions.PropertyConvention;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.web.router.RouteBuilder;
import io.micronaut.web.router.naming.HyphenatedUriNamingStrategy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;

@Singleton
@Requirements(value={@Requires(classes={RouteBuilder.UriNamingStrategy.class}), @Requires(beans={Application.class})})
@Replaces(value=HyphenatedUriNamingStrategy.class)
@Primary
public class JaxRsApplicationUriNamingStrategy
extends HyphenatedUriNamingStrategy {
    private final String contextPath;

    @Inject
    public JaxRsApplicationUriNamingStrategy(BeanContext beanContext) {
        this.contextPath = this.normalizeContextPath(beanContext.getBeanDefinition(Application.class).stringValue(ApplicationPath.class).orElse("/"));
    }

    public String resolveUri(Class type) {
        return this.contextPath + super.resolveUri(type);
    }

    @NonNull
    public String resolveUri(BeanDefinition<?> beanDefinition) {
        return this.contextPath + super.resolveUri(beanDefinition);
    }

    @NonNull
    public String resolveUri(String property) {
        return this.contextPath + super.resolveUri(property);
    }

    @NonNull
    public String resolveUri(Class type, PropertyConvention id) {
        return this.contextPath + super.resolveUri(type, id);
    }

    private String normalizeContextPath(String contextPath) {
        if (((String)contextPath).charAt(0) != '/') {
            contextPath = "/" + (String)contextPath;
        }
        if (((String)contextPath).charAt(((String)contextPath).length() - 1) == '/') {
            contextPath = ((String)contextPath).substring(0, ((String)contextPath).length() - 1);
        }
        return contextPath;
    }
}

