/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.runtime.core;

import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.jaxrs.runtime.core.ParameterParser;
import java.util.Collections;
import java.util.Map;

public class Weighted<T>
implements Comparable<Weighted<T>> {
    private final T object;
    private final float weight;

    public Weighted(T object, Map<String, String> parameters) {
        ArgumentUtils.requireNonNull((String)"object", object);
        this.object = object;
        if (parameters != null) {
            String q = parameters.get("q");
            if (q != null) {
                try {
                    this.weight = Float.parseFloat(q.toString());
                }
                catch (NumberFormatException e) {
                    throw new HttpStatusException(HttpStatus.BAD_REQUEST, "Invalid weight: " + q);
                }
                if (this.weight > 1.0f) {
                    throw new HttpStatusException(HttpStatus.BAD_REQUEST, "Weight [" + q + "] cannot be greater than 1.0");
                }
            } else {
                this.weight = 1.0f;
            }
        } else {
            this.weight = 1.0f;
        }
    }

    public Weighted(T object, float weight) {
        ArgumentUtils.requireNonNull((String)"object", object);
        this.object = object;
        this.weight = weight;
    }

    public Weighted(T object) {
        this(object, 1.0f);
    }

    public T getObject() {
        return this.object;
    }

    public float getWeight() {
        return this.weight;
    }

    @Override
    public int compareTo(Weighted<T> o) {
        ArgumentUtils.requireNonNull((String)"o", o);
        if (this.weight > o.weight) {
            return -1;
        }
        if (this.weight < o.weight) {
            return 1;
        }
        return 0;
    }

    public static Map<String, String> parseParameters(String str) {
        ArgumentUtils.requireNonNull((String)"str", (Object)str);
        int i = str.indexOf(59);
        if (i > -1) {
            return new ParameterParser().parse(str.substring(i), ';');
        }
        return Collections.emptyMap();
    }
}

