/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.runtime.ext.bind;

import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Singleton
public class ContextAnnotationBinder<T>
implements AnnotatedRequestArgumentBinder<Context, T> {
    private final BeanContext beanContext;
    private final Map<Class<?>, TypedRequestArgumentBinder<?>> argBinders;

    @Inject
    protected ContextAnnotationBinder(BeanContext beanContext, Collection<TypedRequestArgumentBinder<?>> argumentBinders) {
        this.beanContext = beanContext;
        this.argBinders = argumentBinders.stream().collect(Collectors.toMap(argBinder -> argBinder.argumentType().getType(), Function.identity(), (dup1, dup2) -> dup1));
    }

    public Class<Context> getAnnotationType() {
        return Context.class;
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        Argument argument = context.getArgument();
        TypedRequestArgumentBinder<?> binder = this.argBinders.get(argument.getType());
        if (binder != null) {
            return binder.bind(context, source);
        }
        Qualifier qualifier = Qualifiers.forArgument((Argument)argument);
        return () -> this.beanContext.findBean(argument, qualifier);
    }
}

