/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.runtime.ext.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.jaxrs.runtime.ext.impl.LinkBuilderImpl;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.List;
import java.util.Map;

@Internal
final class LinkDelegate
implements RuntimeDelegate.HeaderDelegate<Link> {
    LinkDelegate() {
    }

    public Link fromString(String value) throws IllegalArgumentException {
        ArgumentUtils.requireNonNull((String)"value", (Object)value);
        Parser parser = new Parser(value);
        parser.parse();
        return parser.getLink();
    }

    public String toString(Link value) throws IllegalArgumentException {
        ArgumentUtils.requireNonNull((String)"value", (Object)value);
        StringBuilder buf = new StringBuilder("<");
        buf.append(value.getUri().toString()).append(">");
        for (Map.Entry entry : value.getParams().entrySet()) {
            buf.append("; ").append((String)entry.getKey()).append("=\"").append((String)entry.getValue()).append("\"");
        }
        return buf.toString();
    }

    private static final class Parser {
        public static final String PARSE_ERROR_MESSAGE = "Unable to parse Link header.  No end to parameter: ";
        private int curr;
        private final String value;
        private final Link.Builder builder;

        Parser(String value) {
            this.value = value;
            this.builder = new LinkBuilderImpl();
        }

        public Link getLink() {
            return this.builder.build(new Object[0]);
        }

        void parse() {
            String href = null;
            MultivaluedHashMap attributes = new MultivaluedHashMap();
            while (this.curr < this.value.length()) {
                char c = this.value.charAt(this.curr);
                if (c == '<') {
                    if (href != null) {
                        throw new IllegalArgumentException("Unable to parse Link header. Too many links in declaration: " + this.value);
                    }
                    href = this.parseLink();
                    continue;
                }
                if (c == ';' || c == ' ') {
                    ++this.curr;
                    continue;
                }
                this.parseAttribute((MultivaluedMap<String, String>)attributes);
            }
            this.populateLink(href, (MultivaluedMap<String, String>)attributes);
        }

        void populateLink(String href, MultivaluedMap<String, String> attributes) {
            this.builder.uri(href);
            block10: for (Map.Entry entry : attributes.entrySet()) {
                List values = (List)entry.getValue();
                switch ((String)entry.getKey()) {
                    case "rel": {
                        for (String val : values) {
                            this.builder.rel(val);
                        }
                        continue block10;
                    }
                    case "title": {
                        for (String val : values) {
                            this.builder.title(val);
                        }
                        continue block10;
                    }
                    case "type": {
                        for (String val : values) {
                            this.builder.type(val);
                        }
                        continue block10;
                    }
                    default: {
                        for (String val : values) {
                            this.builder.param((String)entry.getKey(), val);
                        }
                        continue block10;
                    }
                }
            }
        }

        String parseLink() {
            int end = this.value.indexOf(62, this.curr);
            if (end == -1) {
                throw new IllegalArgumentException("Unable to parse Link header.  No end to link:" + this.value);
            }
            String href = this.value.substring(this.curr + 1, end);
            this.curr = end + 1;
            return href;
        }

        void parseAttribute(MultivaluedMap<String, String> attributes) {
            String val;
            int end = this.value.indexOf(61, this.curr);
            if (end == -1 || end + 1 >= this.value.length()) {
                throw new IllegalArgumentException(PARSE_ERROR_MESSAGE + this.value);
            }
            String name = this.value.substring(this.curr, end);
            name = name.trim();
            this.curr = end + 1;
            if (this.curr >= this.value.length()) {
                val = "";
            } else if (this.value.charAt(this.curr) == '\"') {
                if (this.curr + 1 >= this.value.length()) {
                    throw new IllegalArgumentException(PARSE_ERROR_MESSAGE + this.value);
                }
                ++this.curr;
                end = this.value.indexOf(34, this.curr);
                if (end == -1) {
                    throw new IllegalArgumentException(PARSE_ERROR_MESSAGE + this.value);
                }
                val = this.value.substring(this.curr, end);
                this.curr = end + 1;
            } else {
                char c;
                StringBuilder buf = new StringBuilder();
                while (this.curr < this.value.length() && (c = this.value.charAt(this.curr)) != ',' && c != ';') {
                    buf.append(this.value.charAt(this.curr));
                    ++this.curr;
                }
                val = buf.toString();
            }
            attributes.add((Object)name, (Object)val);
        }
    }
}

