/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.runtime.core;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Internal
class JaxRsResponse
extends Response {
    private final MutableHttpResponse<Object> response = HttpResponse.ok();

    JaxRsResponse() {
    }

    public MutableHttpResponse<Object> getResponse() {
        return this.response;
    }

    public int getStatus() {
        return this.response.status().getCode();
    }

    public Response.StatusType getStatusInfo() {
        return Response.Status.valueOf((String)this.response.status().name());
    }

    public Object getEntity() {
        return this.response.body();
    }

    public <T> T readEntity(Class<T> entityType) {
        return this.response.getBody(entityType).orElse(null);
    }

    public <T> T readEntity(GenericType<T> entityType) {
        return null;
    }

    public <T> T readEntity(Class<T> entityType, Annotation[] annotations) {
        return this.readEntity(entityType);
    }

    public <T> T readEntity(GenericType<T> entityType, Annotation[] annotations) {
        return this.readEntity(entityType);
    }

    public boolean hasEntity() {
        return this.response.getBody().isPresent();
    }

    public boolean bufferEntity() {
        return false;
    }

    public void close() {
    }

    public MediaType getMediaType() {
        return this.response.getContentType().map(mt -> MediaType.valueOf((String)mt.toString())).orElse(null);
    }

    public Locale getLanguage() {
        return this.response.getLocale().orElse(null);
    }

    public int getLength() {
        return (int)this.response.getContentLength();
    }

    public Set<String> getAllowedMethods() {
        List allow = this.response.getHeaders().getAll((CharSequence)"Allow");
        return new HashSet<String>(allow);
    }

    @Nullable
    public Map<String, NewCookie> getCookies() {
        return null;
    }

    public EntityTag getEntityTag() {
        return this.response.getHeaders().getFirst((CharSequence)"ETag").map(entityTag -> (EntityTag)RuntimeDelegate.getInstance().createHeaderDelegate(EntityTag.class).fromString(entityTag)).orElse(null);
    }

    public Date getDate() {
        return null;
    }

    public Date getLastModified() {
        return null;
    }

    public URI getLocation() {
        return this.response.getHeaders().getFirst((CharSequence)"Location").map(URI::create).orElse(null);
    }

    public Set<Link> getLinks() {
        return Collections.emptySet();
    }

    public boolean hasLink(String relation) {
        return false;
    }

    public Link getLink(String relation) {
        return null;
    }

    public Link.Builder getLinkBuilder(String relation) {
        return null;
    }

    public MultivaluedMap<String, Object> getMetadata() {
        throw new UnsupportedOperationException("Unsupported deprecated method getMetadata()");
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        MutableHttpHeaders headers = this.response.getHeaders();
        Set names = headers.names();
        MultivaluedHashMap map = new MultivaluedHashMap(names.size());
        for (String name : names) {
            List all = headers.getAll((CharSequence)name);
            map.addAll((Object)name, all);
        }
        return map;
    }

    public String getHeaderString(String name) {
        return this.response.getHeaders().getFirst((CharSequence)name).orElse(null);
    }
}

