/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.runtime.core;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.jaxrs.runtime.core.JaxRsResponse;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;

@Internal
public class JaxRsResponseBuilder
extends Response.ResponseBuilder {
    private final JaxRsResponse micronautResponse = new JaxRsResponse();
    private final MutableHttpResponse<Object> response = this.micronautResponse.getResponse();

    public Response build() {
        return this.micronautResponse;
    }

    public Response.ResponseBuilder clone() {
        return new JaxRsResponseBuilder();
    }

    public Response.ResponseBuilder status(int status) {
        this.response.status(status);
        return this;
    }

    public Response.ResponseBuilder status(int status, String reasonPhrase) {
        this.response.status(HttpStatus.valueOf((int)status), (CharSequence)reasonPhrase);
        return this;
    }

    public Response.ResponseBuilder entity(Object entity) {
        this.response.body(entity);
        return this;
    }

    public Response.ResponseBuilder entity(Object entity, Annotation[] annotations) {
        this.entity(entity);
        return this;
    }

    public Response.ResponseBuilder allow(String ... methods) {
        this.response.getHeaders().allowGeneric(Arrays.asList(methods));
        return this;
    }

    public Response.ResponseBuilder allow(Set<String> methods) {
        this.response.getHeaders().allowGeneric(methods);
        return this;
    }

    public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
        if (cacheControl != null) {
            this.response.getHeaders().add((CharSequence)"Cache-Control", (CharSequence)RuntimeDelegate.getInstance().createHeaderDelegate(CacheControl.class).toString((Object)cacheControl));
        }
        return this;
    }

    public Response.ResponseBuilder encoding(String encoding) {
        this.response.header((CharSequence)"Content-Encoding", (CharSequence)encoding);
        return this;
    }

    public Response.ResponseBuilder header(String name, Object value) {
        if (value != null) {
            this.response.header((CharSequence)name, (CharSequence)value.toString());
        } else {
            this.response.getHeaders().remove((CharSequence)name);
        }
        return this;
    }

    public Response.ResponseBuilder replaceAll(MultivaluedMap<String, Object> headers) {
        MutableHttpHeaders finalHeaders = this.response.getHeaders();
        headers.forEach((s, objects) -> {
            finalHeaders.remove((CharSequence)s);
            for (Object object : objects) {
                if (object == null) continue;
                finalHeaders.add((CharSequence)s, (CharSequence)object.toString());
            }
        });
        return this;
    }

    public Response.ResponseBuilder language(String language) {
        this.response.header((CharSequence)"Content-Language", (CharSequence)language);
        return this;
    }

    public Response.ResponseBuilder language(Locale language) {
        this.response.header((CharSequence)"Content-Language", (CharSequence)language.toString());
        return this;
    }

    public Response.ResponseBuilder type(MediaType type) {
        if (type == null) {
            this.response.getHeaders().remove((CharSequence)"Content-Type");
        } else {
            this.response.contentType(new io.micronaut.http.MediaType(type.toString()));
        }
        return this;
    }

    public Response.ResponseBuilder type(String type) {
        if (type == null) {
            this.response.getHeaders().remove((CharSequence)"Content-Type");
        } else {
            this.response.contentType((CharSequence)type);
        }
        return this;
    }

    public Response.ResponseBuilder variant(Variant variant) {
        return this;
    }

    public Response.ResponseBuilder contentLocation(URI location) {
        this.response.getHeaders().location(location);
        return this;
    }

    public Response.ResponseBuilder cookie(NewCookie ... cookies) {
        for (NewCookie cookie : cookies) {
            Date expiry;
            String path;
            Cookie c = Cookie.of((String)cookie.getName(), (String)cookie.getValue());
            String domain = cookie.getDomain();
            if (domain != null) {
                c.domain(domain);
            }
            if ((path = cookie.getPath()) != null) {
                c.path(path);
            }
            if ((expiry = cookie.getExpiry()) != null) {
                long maxAge = expiry.getTime() - new Date().getTime();
                if (maxAge < 0L) {
                    throw new IllegalArgumentException("Expiry should not be in the past");
                }
                c.maxAge(maxAge);
            }
            this.response.cookie(c);
        }
        return this;
    }

    public Response.ResponseBuilder expires(Date expires) {
        MutableHttpHeaders headers = this.response.getHeaders();
        if (expires == null) {
            headers.remove((CharSequence)"Expect");
        } else {
            headers.expires(expires.getTime());
        }
        return this;
    }

    public Response.ResponseBuilder lastModified(Date lastModified) {
        MutableHttpHeaders headers = this.response.getHeaders();
        if (lastModified == null) {
            headers.remove((CharSequence)"Last-Modified");
        } else {
            headers.lastModified(lastModified.getTime());
        }
        return this;
    }

    public Response.ResponseBuilder location(URI location) {
        MutableHttpHeaders headers = this.response.getHeaders();
        if (location == null) {
            headers.remove((CharSequence)"Location");
        } else {
            headers.location(location);
        }
        return this;
    }

    public Response.ResponseBuilder tag(EntityTag tag) {
        if (tag != null) {
            this.response.getHeaders().add((CharSequence)"ETag", (CharSequence)RuntimeDelegate.getInstance().createHeaderDelegate(EntityTag.class).toString((Object)tag));
        }
        return this;
    }

    public Response.ResponseBuilder tag(String tag) {
        if (tag != null) {
            this.response.getHeaders().add((CharSequence)"ETag", (CharSequence)tag);
        }
        return this;
    }

    public Response.ResponseBuilder variants(Variant ... variants) {
        return this;
    }

    public Response.ResponseBuilder variants(List<Variant> variants) {
        return this;
    }

    public Response.ResponseBuilder links(Link ... links) {
        MutableHttpHeaders headers = this.response.getHeaders();
        for (Link link : links) {
            headers.add((CharSequence)"Link", (CharSequence)link.toString());
        }
        return this;
    }

    public Response.ResponseBuilder link(URI uri, String rel) {
        ArgumentUtils.requireNonNull((String)"uri", (Object)uri);
        ArgumentUtils.requireNonNull((String)"rel", (Object)rel);
        Link link = Link.fromUri((URI)uri).rel(rel).build(new Object[0]);
        this.response.getHeaders().add((CharSequence)"Link", (CharSequence)link.toString());
        return this;
    }

    public Response.ResponseBuilder link(String uri, String rel) {
        return this.link(URI.create(uri), rel);
    }
}

