/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.runtime.ext.bind;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpHeaders;
import io.micronaut.jaxrs.runtime.core.Weighted;
import io.micronaut.jaxrs.runtime.ext.impl.CookieHeaderDelegate;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Internal
public class JaxRsHttpHeaders
implements jakarta.ws.rs.core.HttpHeaders {
    private final HttpHeaders httpHeaders;

    public JaxRsHttpHeaders(HttpHeaders httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public List<String> getRequestHeader(String name) {
        return this.httpHeaders.getAll((CharSequence)name);
    }

    public String getHeaderString(String name) {
        return String.join((CharSequence)",", this.httpHeaders.getAll((CharSequence)name));
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        MultivaluedHashMap map = new MultivaluedHashMap(this.getLength());
        this.httpHeaders.forEach((arg_0, arg_1) -> ((MultivaluedMap)map).put(arg_0, arg_1));
        return map;
    }

    public List<MediaType> getAcceptableMediaTypes() {
        List mediaTypes = this.httpHeaders.findFirst((CharSequence)"Accept").map(text -> {
            int len = text.length();
            if (len == 0) {
                return Collections.singletonList(MediaType.valueOf((String)"*/*"));
            }
            if (text.indexOf(44) > -1) {
                return Arrays.stream(text.split(",")).map(str -> {
                    int i = str.indexOf(59);
                    MediaType mt = MediaType.valueOf((String)str);
                    if (i > -1) {
                        return new Weighted<MediaType>(mt, mt.getParameters());
                    }
                    return new Weighted<MediaType>(mt);
                }).sorted().map(Weighted::getObject).toList();
            }
            return Collections.singletonList(MediaType.valueOf((String)text));
        }).orElse(Collections.emptyList());
        return Collections.unmodifiableList(mediaTypes);
    }

    public List<Locale> getAcceptableLanguages() {
        List locales = this.httpHeaders.findFirst((CharSequence)"Accept-Language").map(text -> {
            int len = text.length();
            if (len == 0 || len == 1 && text.charAt(0) == '*') {
                return Collections.emptyList();
            }
            if (text.indexOf(44) > -1) {
                return Arrays.stream(text.split(",")).map(str -> {
                    int i = str.indexOf(59);
                    if (i > -1) {
                        String tag = str.substring(0, i).trim();
                        Map<String, String> params = Weighted.parseParameters(str);
                        return new Weighted<Locale>(Locale.forLanguageTag(tag), params);
                    }
                    return new Weighted<Locale>(Locale.forLanguageTag(str.trim()));
                }).sorted().map(Weighted::getObject).toList();
            }
            return Collections.singletonList(Locale.forLanguageTag(text));
        }).orElse(Collections.emptyList());
        return Collections.unmodifiableList(locales);
    }

    public MediaType getMediaType() {
        return this.httpHeaders.getContentType().map(MediaType::valueOf).orElse(null);
    }

    public Locale getLanguage() {
        return this.httpHeaders.getFirst((CharSequence)"Content-Language").map(Locale::new).orElse(null);
    }

    public Map<String, Cookie> getCookies() {
        List cookieHeaders = this.httpHeaders.getAll((CharSequence)"Set-Cookie");
        LinkedHashMap<String, Cookie> cookies = new LinkedHashMap<String, Cookie>(cookieHeaders.size());
        for (String cookieHeader : cookieHeaders) {
            List<Cookie> parsed = CookieHeaderDelegate.parseCookies(cookieHeader);
            for (Cookie cookie : parsed) {
                cookies.put(cookie.getName(), cookie);
            }
        }
        return Collections.unmodifiableMap(cookies);
    }

    public Date getDate() {
        return null;
    }

    public int getLength() {
        return this.httpHeaders.names().size();
    }
}

