/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.runtime.ext.bind;

import io.micronaut.http.HttpRequest;
import jakarta.ws.rs.core.SecurityContext;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Objects;

public class SimpleSecurityContextImpl
implements SecurityContext {
    private final HttpRequest<?> request;

    protected SimpleSecurityContextImpl(HttpRequest<?> request) {
        this.request = Objects.requireNonNull(request, "Request cannot be null");
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal().orElse(null);
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public String getAuthenticationScheme() {
        Certificate cert = this.request.getCertificate().orElse(null);
        if (cert != null) {
            return "CLIENT_CERT";
        }
        String authorization = (String)this.request.getHeaders().get((CharSequence)"Authorization");
        if (authorization != null && authorization.startsWith("Basic")) {
            return "BASIC";
        }
        return null;
    }
}

