/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.runtime.ext.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.jaxrs.runtime.ext.impl.LinkImpl;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriBuilderException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

@Internal
final class LinkBuilderImpl
implements Link.Builder {
    protected final Map<String, String> map = new HashMap<String, String>();
    private UriBuilder uriBuilder;
    private URI baseUri;

    LinkBuilderImpl() {
    }

    public Link.Builder link(Link link) {
        this.uriBuilder = UriBuilder.fromUri((URI)link.getUri());
        this.map.clear();
        this.map.putAll(link.getParams());
        return this;
    }

    public Link.Builder link(String link) {
        Link l = LinkImpl.valueOf(link);
        return this.link(l);
    }

    public Link.Builder uriBuilder(UriBuilder uriBuilder) {
        this.uriBuilder = uriBuilder.clone();
        return this;
    }

    public Link.Builder uri(URI uri) {
        ArgumentUtils.requireNonNull((String)"uri", (Object)uri);
        this.uriBuilder = UriBuilder.fromUri((URI)uri);
        return this;
    }

    public Link.Builder uri(String uri) throws IllegalArgumentException {
        ArgumentUtils.requireNonNull((String)"uri", (Object)uri);
        this.uriBuilder = UriBuilder.fromUri((String)uri);
        return this;
    }

    public Link.Builder rel(String rel) {
        ArgumentUtils.requireNonNull((String)"rel", (Object)rel);
        String rels = this.map.get("rel");
        this.param("rel", (String)(rels == null ? rel : rels + " " + rel));
        return this;
    }

    public Link.Builder title(String title) {
        ArgumentUtils.requireNonNull((String)"title", (Object)title);
        this.param("title", title);
        return this;
    }

    public Link.Builder type(String type) {
        ArgumentUtils.requireNonNull((String)"type", (Object)type);
        this.param("type", type);
        return this;
    }

    public Link.Builder param(String name, String value) throws IllegalArgumentException {
        ArgumentUtils.requireNonNull((String)"name", (Object)name);
        ArgumentUtils.requireNonNull((String)"value", (Object)value);
        this.map.put(name, value);
        return this;
    }

    public Link build(Object ... values) throws UriBuilderException {
        ArgumentUtils.requireNonNull((String)"values", (Object)values);
        URI built = null;
        built = this.uriBuilder == null ? this.baseUri : this.uriBuilder.build(values);
        if (!built.isAbsolute() && this.baseUri != null) {
            built = this.baseUri.resolve(built);
        }
        return new LinkImpl(built, this.map);
    }

    public Link buildRelativized(URI uri, Object ... values) {
        URI built;
        ArgumentUtils.requireNonNull((String)"uri", (Object)uri);
        ArgumentUtils.requireNonNull((String)"values", (Object)values);
        URI with = built = this.uriBuilder.build(values);
        if (this.baseUri != null) {
            with = this.baseUri.resolve(built);
        }
        return new LinkImpl(uri.relativize(with), this.map);
    }

    public Link.Builder baseUri(URI uri) {
        this.baseUri = uri;
        return this;
    }

    public Link.Builder baseUri(String uri) {
        this.baseUri = URI.create(uri);
        return this;
    }
}

