/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.runtime.core;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import jakarta.inject.Singleton;
import jakarta.ws.rs.WebApplicationException;

@Singleton
@Produces
public class JaxRsExceptionHandler
implements ExceptionHandler<WebApplicationException, HttpResponse<?>> {
    private final ErrorResponseProcessor<?> responseProcessor;

    public JaxRsExceptionHandler(ErrorResponseProcessor<?> responseProcessor) {
        this.responseProcessor = responseProcessor;
    }

    public HttpResponse<?> handle(HttpRequest request, WebApplicationException exception) {
        MutableHttpResponse response = HttpResponse.status((HttpStatus)HttpStatus.valueOf((int)exception.getResponse().getStatus()));
        return this.responseProcessor.processResponse(ErrorContext.builder((HttpRequest)request).errorMessage(exception.getMessage()).cause((Throwable)exception).build(), response);
    }
}

