/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.runtime.core;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.io.Writable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.jaxrs.runtime.core.JaxRsResponse;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import org.reactivestreams.Publisher;

@Filter(value={"/**"})
@Internal
public class JaxRsResponseFilter
implements HttpServerFilter {
    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        return Publishers.map((Publisher)chain.proceed(request), mutableHttpResponse -> {
            Object body = mutableHttpResponse.getBody().orElse(null);
            if (body instanceof JaxRsResponse) {
                JaxRsResponse jrs = body;
                MutableHttpResponse<Object> jaxRsResponse = jrs.getResponse();
                mutableHttpResponse.getAttributes().forEach((arg_0, arg_1) -> jaxRsResponse.setAttribute(arg_0, arg_1));
                mutableHttpResponse.getHeaders().forEach((name, value) -> {
                    for (String val : value) {
                        jaxRsResponse.header((CharSequence)name, (CharSequence)val);
                    }
                });
                Object b = jaxRsResponse.body();
                if (b instanceof StreamingOutput) {
                    final StreamingOutput s = (StreamingOutput)b;
                    jaxRsResponse.body((Object)new Writable(){

                        public void writeTo(OutputStream outputStream, @Nullable Charset charset) throws IOException {
                            s.write(outputStream);
                        }

                        public void writeTo(Writer out) {
                        }
                    });
                }
                return jaxRsResponse;
            }
            return mutableHttpResponse;
        });
    }
}

