/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.runtime.core;

import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.uri.UriBuilder;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.UriBuilderException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;

public class JaxRsUriBuilder
extends jakarta.ws.rs.core.UriBuilder {
    private final UriBuilder uriBuilder;

    public JaxRsUriBuilder() {
        this(UriBuilder.of((CharSequence)"/"));
    }

    JaxRsUriBuilder(UriBuilder uriBuilder) {
        this.uriBuilder = uriBuilder;
    }

    public jakarta.ws.rs.core.UriBuilder clone() {
        return new JaxRsUriBuilder(UriBuilder.of((URI)this.uriBuilder.build()));
    }

    public jakarta.ws.rs.core.UriBuilder uri(URI uri) {
        ArgumentUtils.requireNonNull((String)"uri", (Object)uri);
        this.uriBuilder.replacePath(uri.getPath());
        this.uriBuilder.scheme(uri.getScheme());
        this.uriBuilder.port(uri.getPort());
        this.uriBuilder.fragment(uri.getFragment());
        this.uriBuilder.userInfo(uri.getUserInfo());
        this.uriBuilder.host(uri.getHost());
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder uri(String uriTemplate) {
        return this.uri(URI.create(uriTemplate));
    }

    public jakarta.ws.rs.core.UriBuilder scheme(String scheme) {
        this.uriBuilder.scheme(scheme);
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder schemeSpecificPart(String ssp) {
        throw new UnsupportedOperationException("Method schemeSpecificPart(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder userInfo(String ui) {
        this.uriBuilder.userInfo(ui);
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder host(String host) {
        this.uriBuilder.host(host);
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder port(int port) {
        this.uriBuilder.port(port);
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder replacePath(String path) {
        this.uriBuilder.replacePath(path);
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder path(String path) {
        this.uriBuilder.path(path);
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder path(Class resource) {
        Path annotation = resource.getAnnotation(Path.class);
        if (annotation != null) {
            this.uriBuilder.path(annotation.value());
        }
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder path(Class resource, String method) {
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder path(Method method) {
        Path annotation = method.getAnnotation(Path.class);
        if (annotation != null) {
            this.uriBuilder.path(annotation.value());
        }
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder segment(String ... segments) {
        return this.path(String.join((CharSequence)"/", segments));
    }

    public jakarta.ws.rs.core.UriBuilder replaceMatrix(String matrix) {
        throw new UnsupportedOperationException("Method replaceMatrix(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder matrixParam(String name, Object ... values) {
        throw new UnsupportedOperationException("Method matrixParam(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder replaceMatrixParam(String name, Object ... values) {
        throw new UnsupportedOperationException("Method replaceMatrixParam(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder replaceQuery(String query) {
        throw new UnsupportedOperationException("Method replaceQuery(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder queryParam(String name, Object ... values) {
        this.uriBuilder.queryParam(name, values);
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder replaceQueryParam(String name, Object ... values) {
        throw new UnsupportedOperationException("Method replaceQueryParam(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder fragment(String fragment) {
        this.uriBuilder.fragment(fragment);
        return this;
    }

    public jakarta.ws.rs.core.UriBuilder resolveTemplate(String name, Object value) {
        throw new UnsupportedOperationException("Method resolveTemplate(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder resolveTemplate(String name, Object value, boolean encodeSlashInPath) {
        throw new UnsupportedOperationException("Method resolveTemplate(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder resolveTemplateFromEncoded(String name, Object value) {
        throw new UnsupportedOperationException("Method resolveTemplateFromEncoded(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder resolveTemplates(Map<String, Object> templateValues) {
        throw new UnsupportedOperationException("Method resolveTemplates(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder resolveTemplates(Map<String, Object> templateValues, boolean encodeSlashInPath) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Method resolveTemplates(..) not supported by implementation");
    }

    public jakarta.ws.rs.core.UriBuilder resolveTemplatesFromEncoded(Map<String, Object> templateValues) {
        throw new UnsupportedOperationException("Method resolveTemplateFromEncoded(..) not supported by implementation");
    }

    public URI buildFromMap(Map<String, ?> values) {
        return this.uriBuilder.expand(values);
    }

    public URI buildFromMap(Map<String, ?> values, boolean encodeSlashInPath) throws IllegalArgumentException, UriBuilderException {
        return this.uriBuilder.expand(values);
    }

    public URI buildFromEncodedMap(Map<String, ?> values) throws IllegalArgumentException, UriBuilderException {
        return this.uriBuilder.expand(values);
    }

    public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return this.uriBuilder.build();
    }

    public URI build(Object[] values, boolean encodeSlashInPath) throws IllegalArgumentException, UriBuilderException {
        return this.uriBuilder.build();
    }

    public URI buildFromEncoded(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return this.uriBuilder.build();
    }

    public String toTemplate() {
        return this.uriBuilder.toString();
    }
}

