/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.runtime.ext.impl;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.jaxrs.runtime.ext.impl.ServerCookie;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.ArrayList;
import java.util.List;

@Internal
public final class CookieHeaderDelegate
implements RuntimeDelegate.HeaderDelegate<Cookie> {
    public Cookie fromString(String value) throws IllegalArgumentException {
        return CookieHeaderDelegate.parseCookies(value).get(0);
    }

    public String toString(Cookie value) {
        StringBuilder buf = new StringBuilder();
        ServerCookie.appendCookieValue(buf, 0, value.getName(), value.getValue(), value.getPath(), value.getDomain(), null, -1, false);
        return buf.toString();
    }

    public static List<Cookie> parseCookies(String cookieHeader) {
        ArgumentUtils.requireNonNull((String)"cookieHeader", (Object)cookieHeader);
        try {
            String[] parts;
            ArrayList<Cookie> cookies = new ArrayList<Cookie>();
            int version = 0;
            String domain = null;
            String path = null;
            String cookieName = null;
            String cookieValue = null;
            for (String part : parts = cookieHeader.split("[;,]")) {
                String value;
                String[] nv = part.split("=", 2);
                String name = nv.length > 0 ? nv[0].trim() : "";
                String string = value = nv.length > 1 ? nv[1].trim() : "";
                if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
                    value = value.substring(1, value.length() - 1);
                }
                if (!name.startsWith("$")) {
                    if (cookieName != null) {
                        cookies.add(((Cookie.Builder)((Cookie.Builder)((Cookie.Builder)((Cookie.Builder)new Cookie.Builder(cookieName).value(cookieValue)).path(path)).domain(domain)).version(version)).build());
                    }
                    cookieName = name;
                    cookieValue = value;
                    continue;
                }
                if (name.equalsIgnoreCase("$Version")) {
                    version = Integer.parseInt(value);
                    continue;
                }
                if (name.equalsIgnoreCase("$Path")) {
                    path = value;
                    continue;
                }
                if (!name.equalsIgnoreCase("$Domain")) continue;
                domain = value;
            }
            if (cookieName != null) {
                cookies.add(((Cookie.Builder)((Cookie.Builder)((Cookie.Builder)((Cookie.Builder)new Cookie.Builder(cookieName).value(cookieValue)).path(path)).domain(domain)).version(version)).build());
            }
            return cookies;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid cookie header: " + ex.getMessage(), ex);
        }
    }
}

