/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.runtime.ext.bind;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Internal
public final class UriInfoImpl
implements UriInfo {
    private final HttpRequest<?> request;

    public UriInfoImpl(HttpRequest<?> request) {
        this.request = request;
    }

    private String string(String str, boolean decode) {
        return decode ? URLDecoder.decode(str, StandardCharsets.UTF_8) : str;
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        return this.string(this.request.getPath(), decode);
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        return Stream.of(this.request.getPath().split("/")).filter(StringUtils::isNotEmpty).map(token -> {
            String[] segmentTokens = token.split(";");
            MultiMapNullPermitted params = new MultiMapNullPermitted();
            for (int i = 1; i < segmentTokens.length; ++i) {
                String[] keyVal = segmentTokens[i].split("=", 2);
                String key = keyVal[0];
                String val = keyVal.length > 1 ? keyVal[1] : null;
                params.add(this.string(key, decode), this.string(val, decode));
            }
            return new UriPathSegment(this.string(segmentTokens[0], decode), (MultivaluedMap<String, String>)params);
        }).collect(Collectors.toList());
    }

    public URI getRequestUri() {
        return this.request.getUri();
    }

    public UriBuilder getRequestUriBuilder() {
        throw new UnsupportedOperationException();
    }

    public URI getAbsolutePath() {
        return this.getBaseUri().resolve(this.getPath(false));
    }

    public UriBuilder getAbsolutePathBuilder() {
        throw new UnsupportedOperationException();
    }

    public URI getBaseUri() {
        URI uri = this.request.getUri();
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), "", uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unexpected URI format: " + uri.toASCIIString(), e);
        }
    }

    public UriBuilder getBaseUriBuilder() {
        throw new UnsupportedOperationException();
    }

    public MultivaluedMap<String, String> getPathParameters() {
        throw new UnsupportedOperationException();
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        throw new UnsupportedOperationException();
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        MultivaluedHashMap map = new MultivaluedHashMap();
        this.request.getParameters().forEach((arg_0, arg_1) -> this.lambda$getQueryParameters$2((MultivaluedMap)map, decode, arg_0, arg_1));
        return map;
    }

    public List<String> getMatchedURIs() {
        throw new UnsupportedOperationException();
    }

    public List<String> getMatchedURIs(boolean decode) {
        throw new UnsupportedOperationException();
    }

    public List<Object> getMatchedResources() {
        throw new UnsupportedOperationException();
    }

    public URI resolve(URI uri) {
        return this.request.getUri().resolve(uri);
    }

    public URI relativize(URI uri) {
        return this.request.getUri().relativize(uri);
    }

    private /* synthetic */ void lambda$getQueryParameters$2(MultivaluedMap map, boolean decode, String str, List vals) {
        vals.forEach(val -> map.add((Object)this.string(str, decode), (Object)this.string((String)val, decode)));
    }

    private static final class MultiMapNullPermitted<K, V>
    extends MultivaluedHashMap<K, V> {
        protected void addNull(List<V> values) {
            values.add(null);
        }
    }

    private record UriPathSegment(String path, MultivaluedMap<String, String> params) implements PathSegment
    {
        public String getPath() {
            return this.path;
        }

        public MultivaluedMap<String, String> getMatrixParameters() {
            return this.params;
        }
    }
}

