/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.container;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Singleton;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.core.Application;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

@Internal
@Singleton
public final class ApplicationPathProvider {
    private final String path;

    ApplicationPathProvider(BeanContext beanContext, @Value(value="${micronaut.server.context-path}") @Nullable String contextPath) {
        String applicationPath = beanContext.findBeanDefinition(Application.class).flatMap(bd -> bd.stringValue(ApplicationPath.class)).map(path -> URLDecoder.decode(path, StandardCharsets.UTF_8)).orElse("/");
        this.path = this.concatContextPath(contextPath, applicationPath);
    }

    @NonNull
    public String getPath() {
        return this.path;
    }

    @NonNull
    private String concatContextPath(@Nullable String contextPath, @NonNull String applicationPath) {
        if (contextPath == null || contextPath.isEmpty() || contextPath.endsWith("/")) {
            return this.normalizeContextPath(applicationPath);
        }
        return this.normalizeContextPath(this.normalizeContextPath(contextPath).concat(this.normalizeContextPath(applicationPath)));
    }

    private String normalizeContextPath(String contextPath) {
        if (!((String)contextPath).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        if (((String)contextPath).charAt(((String)contextPath).length() - 1) == '/') {
            contextPath = ((String)contextPath).substring(0, ((String)contextPath).length() - 1);
        }
        return contextPath;
    }
}

