/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.container;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.conventions.PropertyConvention;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.jaxrs.container.ApplicationPathProvider;
import io.micronaut.web.router.RouteBuilder;
import io.micronaut.web.router.naming.HyphenatedUriNamingStrategy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;

@Singleton
@Requires(classes={RouteBuilder.UriNamingStrategy.class})
@Replaces(value=HyphenatedUriNamingStrategy.class)
@Primary
@Internal
public final class JaxRsApplicationUriNamingStrategy
extends HyphenatedUriNamingStrategy {
    private final String contextPath;

    @Inject
    public JaxRsApplicationUriNamingStrategy(ApplicationPathProvider applicationPathProvider) {
        this.contextPath = applicationPathProvider.getPath();
    }

    @Deprecated
    public JaxRsApplicationUriNamingStrategy(BeanContext beanContext, @Value(value="${micronaut.server.context-path}") @Nullable String contextPath) {
        this.contextPath = contextPath;
    }

    @Deprecated
    public JaxRsApplicationUriNamingStrategy(BeanContext beanContext) {
        this(beanContext, null);
    }

    public String resolveUri(Class type) {
        return this.contextPath + super.resolveUri(type);
    }

    @NonNull
    public String resolveUri(BeanDefinition<?> beanDefinition) {
        return this.contextPath + super.resolveUri(beanDefinition);
    }

    @NonNull
    public String resolveUri(String property) {
        return this.contextPath + super.resolveUri(property);
    }

    @NonNull
    public String resolveUri(Class type, PropertyConvention id) {
        return this.contextPath + super.resolveUri(type, id);
    }
}

