/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.container;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.jaxrs.common.JaxRsHttpHeaders;
import io.micronaut.jaxrs.common.JaxRsMutableHeadersMultivaluedMap;
import io.micronaut.jaxrs.common.JaxRsMutableHttpHeaders;
import io.micronaut.jaxrs.container.ApplicationPathProvider;
import io.micronaut.jaxrs.runtime.ext.bind.UriInfoImpl;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;

@Internal
final class JaxRsContainerRequestContext
implements ContainerRequestContext {
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private final MutableHttpRequest<?> mutableHttpRequest;
    private final JaxRsHttpHeaders jaxRsHttpHeaders;
    private Response response;
    private final ApplicationPathProvider applicationPathProvider;
    private boolean finished;
    private final boolean preMatching = false;

    JaxRsContainerRequestContext(MutableHttpRequest<?> mutableHttpRequest, ApplicationPathProvider applicationPathProvider) {
        this.mutableHttpRequest = mutableHttpRequest;
        this.applicationPathProvider = applicationPathProvider;
        this.jaxRsHttpHeaders = JaxRsMutableHttpHeaders.forRequest((MutableHttpHeaders)mutableHttpRequest.getHeaders());
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public void setProperty(String name, Object object) {
        this.properties.put(name, object);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public UriInfo getUriInfo() {
        return new UriInfoImpl((HttpRequest<?>)this.mutableHttpRequest, this.applicationPathProvider.getPath());
    }

    public void setRequestUri(URI requestUri) {
        this.checkIsRequestPreMatchingInProgress();
        this.mutableHttpRequest.uri(requestUri);
    }

    public void setRequestUri(URI baseUri, URI requestUri) {
        this.checkIsRequestPreMatchingInProgress();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Request getRequest() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getMethod() {
        return this.mutableHttpRequest.getMethod().name();
    }

    public void setMethod(String method) {
        this.checkIsRequestPreMatchingInProgress();
        throw new IllegalArgumentException("Not supported");
    }

    public MultivaluedMap<String, String> getHeaders() {
        return new JaxRsMutableHeadersMultivaluedMap((MutableHeaders)this.mutableHttpRequest.getHeaders());
    }

    public String getHeaderString(String name) {
        return this.jaxRsHttpHeaders.getHeaderString(name);
    }

    public boolean containsHeaderString(String name, String valueSeparatorRegex, Predicate<String> valuePredicate) {
        return this.jaxRsHttpHeaders.containsHeaderString(name, valueSeparatorRegex, valuePredicate);
    }

    public boolean containsHeaderString(String name, Predicate<String> valuePredicate) {
        return this.jaxRsHttpHeaders.containsHeaderString(name, valuePredicate);
    }

    public Date getDate() {
        return this.jaxRsHttpHeaders.getDate();
    }

    public Locale getLanguage() {
        return this.jaxRsHttpHeaders.getLanguage();
    }

    public int getLength() {
        return this.jaxRsHttpHeaders.getLength();
    }

    public MediaType getMediaType() {
        return this.jaxRsHttpHeaders.getMediaType();
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return this.jaxRsHttpHeaders.getAcceptableMediaTypes();
    }

    public List<Locale> getAcceptableLanguages() {
        return this.jaxRsHttpHeaders.getAcceptableLanguages();
    }

    public Map<String, Cookie> getCookies() {
        return this.jaxRsHttpHeaders.getCookies();
    }

    public boolean hasEntity() {
        return this.mutableHttpRequest.getBody().isPresent();
    }

    public InputStream getEntityStream() {
        return null;
    }

    public void setEntityStream(InputStream input) {
        this.checkRequestFilteringInProgress();
    }

    public SecurityContext getSecurityContext() {
        return null;
    }

    public void setSecurityContext(SecurityContext context) {
        this.checkRequestFilteringInProgress();
    }

    public void abortWith(Response response) {
        this.checkRequestFilteringInProgress();
        this.response = response;
    }

    public Response getResponse() {
        return this.response;
    }

    public void finished() {
        this.finished = true;
    }

    private void checkRequestFilteringInProgress() {
        if (this.finished) {
            throw new IllegalStateException("Request is already commited");
        }
    }

    private void checkIsRequestPreMatchingInProgress() {
        throw new IllegalStateException("Request is already commited");
    }
}

