/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.container;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.jaxrs.common.JaxRsArgumentUtil;
import io.micronaut.jaxrs.common.JaxRsHttpHeaders;
import io.micronaut.jaxrs.common.JaxRsMutableResponse;
import io.micronaut.jaxrs.common.JaxRsUtils;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

@Internal
final class JaxRsContainerResponseContext
implements ContainerResponseContext {
    private final MutableHttpResponse<?> mutableHttpResponse;
    private final JaxRsMutableResponse jaxRsMutableResponse;
    private Argument<?> bodyArgument;

    public JaxRsContainerResponseContext(MutableHttpResponse<?> mutableHttpResponse, Argument<?> bodyArgument) {
        this.mutableHttpResponse = mutableHttpResponse;
        this.jaxRsMutableResponse = new JaxRsMutableResponse(mutableHttpResponse);
        this.bodyArgument = bodyArgument;
    }

    public int getStatus() {
        return this.mutableHttpResponse.getStatus().getCode();
    }

    public void setStatus(int code) {
        this.mutableHttpResponse.status(code);
    }

    public Response.StatusType getStatusInfo() {
        return this.jaxRsMutableResponse.getStatusInfo();
    }

    public void setStatusInfo(Response.StatusType statusInfo) {
        this.mutableHttpResponse.status(statusInfo.getStatusCode());
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.jaxRsMutableResponse.getHeaders();
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return this.jaxRsMutableResponse.getStringHeaders();
    }

    public String getHeaderString(String name) {
        return this.jaxRsMutableResponse.getHeaderString(name);
    }

    public boolean containsHeaderString(String name, String valueSeparatorRegex, Predicate<String> valuePredicate) {
        return JaxRsHttpHeaders.forResponse((HttpHeaders)this.mutableHttpResponse.getHeaders()).containsHeaderString(name, valueSeparatorRegex, valuePredicate);
    }

    public boolean containsHeaderString(String name, Predicate<String> valuePredicate) {
        return JaxRsHttpHeaders.forResponse((HttpHeaders)this.mutableHttpResponse.getHeaders()).containsHeaderString(name, valuePredicate);
    }

    public Set<String> getAllowedMethods() {
        return this.jaxRsMutableResponse.getAllowedMethods();
    }

    public Date getDate() {
        return this.jaxRsMutableResponse.getDate();
    }

    public Locale getLanguage() {
        return this.jaxRsMutableResponse.getLanguage();
    }

    public int getLength() {
        return this.jaxRsMutableResponse.getLength();
    }

    public MediaType getMediaType() {
        return this.jaxRsMutableResponse.getMediaType();
    }

    public Map<String, NewCookie> getCookies() {
        return this.jaxRsMutableResponse.getCookies();
    }

    public EntityTag getEntityTag() {
        return this.jaxRsMutableResponse.getEntityTag();
    }

    public Date getLastModified() {
        return this.jaxRsMutableResponse.getLastModified();
    }

    public URI getLocation() {
        return this.jaxRsMutableResponse.getLocation();
    }

    public Set<Link> getLinks() {
        return this.jaxRsMutableResponse.getLinks();
    }

    public boolean hasLink(String relation) {
        return this.jaxRsMutableResponse.hasLink(relation);
    }

    public Link getLink(String relation) {
        return this.jaxRsMutableResponse.getLink(relation);
    }

    public Link.Builder getLinkBuilder(String relation) {
        return this.jaxRsMutableResponse.getLinkBuilder(relation);
    }

    public boolean hasEntity() {
        return this.jaxRsMutableResponse.hasEntity();
    }

    public Object getEntity() {
        return this.jaxRsMutableResponse.getEntity();
    }

    public Class<?> getEntityClass() {
        return this.bodyArgument.getType();
    }

    public Type getEntityType() {
        return this.bodyArgument.asType();
    }

    public void setEntity(Object entity) {
        this.mutableHttpResponse.body(entity);
    }

    public void setEntity(Object entity, Annotation[] annotations, MediaType mediaType) {
        this.mutableHttpResponse.body(entity);
        if (mediaType != null) {
            this.mutableHttpResponse.contentType(JaxRsUtils.convert((MediaType)mediaType));
        }
        this.bodyArgument = Argument.of(entity == null ? Object.class : entity.getClass(), (AnnotationMetadata)JaxRsArgumentUtil.createAnnotationMetadata((Annotation[])annotations), (Argument[])new Argument[0]);
    }

    public Annotation[] getEntityAnnotations() {
        return this.bodyArgument.getAnnotationMetadata().synthesizeAll();
    }

    public OutputStream getEntityStream() {
        throw new UnsupportedOperationException();
    }

    public void setEntityStream(OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    public Argument<?> getBodyArgument() {
        return this.bodyArgument;
    }
}

