/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.container;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.jaxrs.container.ApplicationPathProvider;
import io.micronaut.jaxrs.runtime.ext.bind.UriInfoImpl;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.List;

@Internal
@Singleton
final class JaxRsContextUriInfo
implements UriInfo {
    private final ApplicationPathProvider applicationPathProvider;

    JaxRsContextUriInfo(ApplicationPathProvider applicationPathProvider) {
        this.applicationPathProvider = applicationPathProvider;
    }

    private UriInfoImpl getUriInfo() {
        return new UriInfoImpl((HttpRequest)ServerRequestContext.currentRequest().get(), this.applicationPathProvider.getPath());
    }

    public String getPath() {
        return this.getUriInfo().getPath();
    }

    public String getPath(boolean decode) {
        return this.getUriInfo().getPath(decode);
    }

    public List<PathSegment> getPathSegments() {
        return this.getUriInfo().getPathSegments();
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        return this.getUriInfo().getPathSegments();
    }

    public URI getRequestUri() {
        return this.getUriInfo().getRequestUri();
    }

    public UriBuilder getRequestUriBuilder() {
        return this.getUriInfo().getRequestUriBuilder();
    }

    public URI getAbsolutePath() {
        return this.getUriInfo().getAbsolutePath();
    }

    public UriBuilder getAbsolutePathBuilder() {
        return this.getUriInfo().getAbsolutePathBuilder();
    }

    public URI getBaseUri() {
        return this.getUriInfo().getBaseUri();
    }

    public UriBuilder getBaseUriBuilder() {
        return this.getUriInfo().getBaseUriBuilder();
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getUriInfo().getPathParameters();
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        return this.getUriInfo().getPathParameters(decode);
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getUriInfo().getQueryParameters();
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        return this.getUriInfo().getQueryParameters(decode);
    }

    public List<String> getMatchedURIs() {
        return this.getUriInfo().getMatchedURIs();
    }

    public String getMatchedResourceTemplate() {
        return "";
    }

    public List<String> getMatchedURIs(boolean decode) {
        return this.getUriInfo().getMatchedURIs(decode);
    }

    public List<Object> getMatchedResources() {
        return this.getUriInfo().getMatchedResources();
    }

    public URI resolve(URI uri) {
        return this.getUriInfo().resolve(uri);
    }

    public URI relativize(URI uri) {
        return this.getUriInfo().relativize(uri);
    }
}

