/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.container;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ResponseFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.jaxrs.common.JaxRsArgumentUtil;
import io.micronaut.jaxrs.common.JaxRsGenericEntity;
import io.micronaut.jaxrs.common.JaxRsMutableResponse;
import io.micronaut.jaxrs.common.JaxRsResponse;
import io.micronaut.jaxrs.common.JaxRsUtils;
import io.micronaut.jaxrs.container.ApplicationPathProvider;
import io.micronaut.jaxrs.container.JaxRsContainerRequestContext;
import io.micronaut.jaxrs.container.JaxRsContainerResponseContext;
import io.micronaut.web.router.RouteInfo;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.List;

@ServerFilter(value={"/**"})
@Internal
final class JaxRsFilters {
    private static final String REQUEST_CONTEXT_KEY = ContainerRequestFilter.class.getName();
    private final ApplicationPathProvider applicationPathProvider;
    private final List<ContainerRequestFilter> requestFilters;
    private final List<ContainerResponseFilter> containerResponseFilters;

    JaxRsFilters(ApplicationPathProvider applicationPathProvider, List<ContainerRequestFilter> requestFilters, List<ContainerResponseFilter> containerResponseFilters) {
        this.applicationPathProvider = applicationPathProvider;
        this.requestFilters = requestFilters;
        JaxRsUtils.sortByPriority(requestFilters);
        this.containerResponseFilters = containerResponseFilters;
        JaxRsUtils.sortByPriorityReversed(containerResponseFilters);
    }

    @Nullable
    @RequestFilter
    HttpResponse<?> filterRequest(MutableHttpRequest<?> request) throws IOException {
        if (this.requestFilters.isEmpty()) {
            return null;
        }
        JaxRsContainerRequestContext requestContext = new JaxRsContainerRequestContext(request, this.applicationPathProvider);
        if (!this.containerResponseFilters.isEmpty()) {
            request.setAttribute((CharSequence)REQUEST_CONTEXT_KEY, (Object)requestContext);
        }
        for (ContainerRequestFilter requestFilter : this.requestFilters) {
            requestFilter.filter((ContainerRequestContext)requestContext);
            Response response = requestContext.getResponse();
            if (response == null || !(response instanceof JaxRsResponse)) continue;
            JaxRsResponse jaxRsResponse = (JaxRsResponse)response;
            return jaxRsResponse.getResponse();
        }
        requestContext.finished();
        return null;
    }

    @ResponseFilter
    MutableHttpResponse<?> filterResponse(HttpRequest<?> request, MutableHttpResponse<?> mutableHttpResponse) throws IOException {
        Object body = request.getMethod() == HttpMethod.HEAD ? mutableHttpResponse.getAttribute((CharSequence)HttpAttributes.HEAD_BODY).orElse(null) : mutableHttpResponse.getBody().orElse(null);
        if (body instanceof JaxRsMutableResponse) {
            JaxRsMutableResponse jrs = (JaxRsMutableResponse)body;
            MutableHttpResponse jaxRsResponse = jrs.getResponse();
            mutableHttpResponse.getAttributes().forEach((arg_0, arg_1) -> ((MutableHttpResponse)jaxRsResponse).setAttribute(arg_0, arg_1));
            mutableHttpResponse.getHeaders().forEach((name, value) -> {
                for (String val : value) {
                    jaxRsResponse.header((CharSequence)name, (CharSequence)val);
                }
            });
            mutableHttpResponse = jaxRsResponse;
            body = mutableHttpResponse.getBody().orElse(null);
        }
        if (!this.containerResponseFilters.isEmpty()) {
            GenericEntity genericEntity;
            Argument bodyArgument = null;
            if (body instanceof JaxRsGenericEntity) {
                JaxRsGenericEntity genericEntity2 = (JaxRsGenericEntity)body;
                bodyArgument = genericEntity2.asArgument();
                mutableHttpResponse.body(genericEntity2.getEntity());
            } else if (body instanceof GenericEntity) {
                GenericEntity genericEntity3 = (GenericEntity)body;
                bodyArgument = JaxRsArgumentUtil.from((GenericEntity)genericEntity3);
                mutableHttpResponse.body(genericEntity3.getEntity());
            } else if (body != null) {
                bodyArgument = Argument.of(body.getClass());
            }
            RouteInfo routeInfo = request.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, RouteInfo.class).orElse(null);
            if (routeInfo != null) {
                Argument returnType = routeInfo.getReturnType().asArgument();
                if (bodyArgument == null) {
                    bodyArgument = returnType;
                } else {
                    MutableAnnotationMetadata mutableAnnotationMetadata = new MutableAnnotationMetadata();
                    mutableAnnotationMetadata.addAnnotationMetadata(MutableAnnotationMetadata.of((AnnotationMetadata)returnType.getAnnotationMetadata()));
                    mutableAnnotationMetadata.addAnnotationMetadata(MutableAnnotationMetadata.of((AnnotationMetadata)bodyArgument.getAnnotationMetadata()));
                    bodyArgument = Argument.of((Class)bodyArgument.getType(), (AnnotationMetadata)mutableAnnotationMetadata, (Argument[])bodyArgument.getTypeParameters());
                }
            }
            JaxRsContainerRequestContext requestContext = request.getAttribute((CharSequence)REQUEST_CONTEXT_KEY, JaxRsContainerRequestContext.class).orElseGet(() -> new JaxRsContainerRequestContext(request.mutate(), this.applicationPathProvider));
            requestContext.finished();
            JaxRsContainerResponseContext responseContext = new JaxRsContainerResponseContext(mutableHttpResponse, bodyArgument);
            for (ContainerResponseFilter responseFilter : this.containerResponseFilters) {
                responseFilter.filter((ContainerRequestContext)requestContext, (ContainerResponseContext)responseContext);
            }
            if (body instanceof GenericEntity && (genericEntity = (GenericEntity)body).getEntity() == mutableHttpResponse.getBody() && bodyArgument == responseContext.getBodyArgument()) {
                mutableHttpResponse.body(body);
            }
        }
        return mutableHttpResponse;
    }
}

