/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.container;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.jaxrs.common.JaxRsMutableResponse;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Providers;

@Singleton
@Produces
@Internal
final class JaxRsGlobalExceptionHandler
implements ExceptionHandler<Throwable, HttpResponse<?>> {
    private final ErrorResponseProcessor<?> responseProcessor;
    private final Providers providers;

    @Inject
    JaxRsGlobalExceptionHandler(ErrorResponseProcessor<?> responseProcessor, Providers providers) {
        this.responseProcessor = responseProcessor;
        this.providers = providers;
    }

    public HttpResponse<?> handle(HttpRequest request, Throwable exception) {
        ExceptionMapper exceptionMapper = this.providers.getExceptionMapper(exception.getClass());
        if (exceptionMapper != null) {
            return ((JaxRsMutableResponse)exceptionMapper.toResponse(exception)).getResponse();
        }
        return this.responseProcessor.processResponse(ErrorContext.builder((HttpRequest)request).errorMessage(exception.getMessage()).cause(exception).build(), HttpResponse.badRequest());
    }
}

