/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.container;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

@Internal
final class JaxRsResponseMessageBodyWriter
implements MessageBodyWriter<Response> {
    private final MessageBodyHandlerRegistry registry;

    JaxRsResponseMessageBodyWriter(MessageBodyHandlerRegistry registry) {
        this.registry = registry;
    }

    public void writeTo(@NonNull Argument<Response> type, @NonNull MediaType mediaType, Response object, @NonNull MutableHeaders outgoingHeaders, @NonNull OutputStream outputStream) throws CodecException {
        object.getStringHeaders().forEach((name, list) -> {
            for (String value : list) {
                outgoingHeaders.add((CharSequence)name, (CharSequence)value);
            }
        });
        if (object.hasEntity()) {
            Object entity = object.getEntity();
            Argument argument = Argument.ofInstance((Object)entity);
            this.registry.getWriter(argument, List.of(mediaType)).writeTo(argument, mediaType, entity, outgoingHeaders, outputStream);
        } else {
            try {
                outputStream.flush();
            }
            catch (IOException e) {
                throw new CodecException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

