/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.runtime.ext.bind;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.web.router.RouteMatch;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

@Internal
public final class UriInfoImpl
implements UriInfo {
    private final HttpRequest<?> request;
    private final String basePath;

    public UriInfoImpl(@NonNull HttpRequest<?> request, @Nullable String basePath) {
        this.request = request;
        this.basePath = basePath == null || basePath.equals("/") ? null : basePath;
    }

    public UriInfoImpl(@NonNull HttpRequest<?> request) {
        this(request, null);
    }

    private String getPath(String requestPath, boolean decode) {
        String path;
        String string = path = decode ? URLDecoder.decode(requestPath, StandardCharsets.UTF_8) : requestPath;
        if (this.basePath != null) {
            Object pathToCheck = path;
            if (!path.startsWith("/")) {
                pathToCheck = "/" + path;
            }
            if (((String)pathToCheck).startsWith(this.basePath)) {
                return ((String)pathToCheck).substring(this.basePath.length());
            }
        }
        return path;
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        return this.getPath(this.request.getPath(), decode);
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        return Stream.of(this.request.getPath().split("/")).filter(StringUtils::isNotEmpty).map(token -> {
            String[] segmentTokens = token.split(";");
            MultiMapNullPermitted params = new MultiMapNullPermitted();
            for (int i = 1; i < segmentTokens.length; ++i) {
                String[] keyVal = segmentTokens[i].split("=", 2);
                String key = keyVal[0];
                String val = keyVal.length > 1 ? keyVal[1] : null;
                params.add(this.getPath(key, decode), this.getPath(val, decode));
            }
            return new UriPathSegment(this.getPath(segmentTokens[0], decode), (MultivaluedMap<String, String>)params);
        }).toList();
    }

    public URI getRequestUri() {
        return this.request.getUri();
    }

    public UriBuilder getRequestUriBuilder() {
        throw new UnsupportedOperationException();
    }

    public URI getAbsolutePath() {
        return this.getBaseUri().resolve(this.getPath(false));
    }

    public UriBuilder getAbsolutePathBuilder() {
        throw new UnsupportedOperationException();
    }

    public URI getBaseUri() {
        URI uri = this.request.getUri();
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), "", uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unexpected URI format: " + uri.toASCIIString(), e);
        }
    }

    public UriBuilder getBaseUriBuilder() {
        throw new UnsupportedOperationException();
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        RouteMatch match = (RouteMatch)this.request.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, RouteMatch.class).orElseThrow(() -> new IllegalStateException("Route match not available!"));
        MultivaluedHashMap map = new MultivaluedHashMap();
        if (decode) {
            match.getVariableValues().forEach((arg_0, arg_1) -> UriInfoImpl.lambda$getPathParameters$2((MultivaluedMap)map, arg_0, arg_1));
        } else {
            match.getVariableValues().forEach((arg_0, arg_1) -> UriInfoImpl.lambda$getPathParameters$3((MultivaluedMap)map, arg_0, arg_1));
        }
        return map;
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        MultivaluedHashMap map = new MultivaluedHashMap();
        if (decode) {
            this.request.getParameters().forEach((arg_0, arg_1) -> this.lambda$getQueryParameters$5((MultivaluedMap)map, decode, arg_0, arg_1));
        } else {
            UriInfoImpl.getEncodedParameters(this.request.getUri()).forEach((arg_0, arg_1) -> UriInfoImpl.lambda$getQueryParameters$7((MultivaluedMap)map, arg_0, arg_1));
        }
        return map;
    }

    public static Map<String, List<String>> getEncodedParameters(URI url) {
        String[] pairs;
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        for (String pair : pairs = url.getRawQuery().split("&")) {
            int idx = pair.indexOf("=");
            String key = idx > 0 ? pair.substring(0, idx) : pair;
            String value = idx > 0 && pair.length() > idx + 1 ? pair.substring(idx + 1) : null;
            ArrayList<String> list = (ArrayList<String>)map.get(key);
            if (list == null) {
                list = new ArrayList<String>();
                map.put(key, list);
            }
            list.add(value);
        }
        return map;
    }

    public List<String> getMatchedURIs() {
        throw new UnsupportedOperationException();
    }

    public String getMatchedResourceTemplate() {
        return "";
    }

    public List<String> getMatchedURIs(boolean decode) {
        throw new UnsupportedOperationException();
    }

    public List<Object> getMatchedResources() {
        throw new UnsupportedOperationException();
    }

    public URI resolve(URI uri) {
        return this.request.getUri().resolve(uri);
    }

    public URI relativize(URI uri) {
        return this.request.getUri().relativize(uri);
    }

    private static /* synthetic */ void lambda$getQueryParameters$7(MultivaluedMap map, String str, List vals) {
        vals.forEach(val -> map.add((Object)str, val));
    }

    private /* synthetic */ void lambda$getQueryParameters$5(MultivaluedMap map, boolean decode, String str, List vals) {
        vals.forEach(val -> map.add((Object)this.getPath(str, decode), (Object)this.getPath((String)val, decode)));
    }

    private static /* synthetic */ void lambda$getPathParameters$3(MultivaluedMap map, String name, Object value) {
        map.add((Object)name, (Object)URLEncoder.encode(value.toString(), StandardCharsets.UTF_8).replace("+", "%20"));
    }

    private static /* synthetic */ void lambda$getPathParameters$2(MultivaluedMap map, String name, Object value) {
        map.add((Object)name, (Object)value.toString());
    }

    private static final class MultiMapNullPermitted<K, V>
    extends MultivaluedHashMap<K, V> {
        private MultiMapNullPermitted() {
        }

        protected void addNull(List<V> values) {
            values.add(null);
        }
    }

    private record UriPathSegment(String path, MultivaluedMap<String, String> params) implements PathSegment
    {
        public String getPath() {
            return this.path;
        }

        public MultivaluedMap<String, String> getMatrixParameters() {
            return this.params;
        }
    }
}

