/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.container;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerHttpRequestContext;
import io.micronaut.jaxrs.common.JaxRsHttpHeaders;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;

@Internal
@Singleton
final class JaxRsContextHttpHeaders
implements jakarta.ws.rs.core.HttpHeaders {
    JaxRsContextHttpHeaders() {
    }

    private JaxRsHttpHeaders getHeaders() {
        HttpRequest httpRequest = ServerHttpRequestContext.get();
        if (httpRequest == null) {
            throw new IllegalStateException("Cannot find required request");
        }
        return JaxRsHttpHeaders.forRequest((HttpHeaders)httpRequest.getHeaders());
    }

    public List<String> getRequestHeader(String name) {
        return this.getHeaders().getRequestHeader(name);
    }

    public String getHeaderString(String name) {
        return this.getHeaders().getHeaderString(name);
    }

    public boolean containsHeaderString(String name, String valueSeparatorRegex, Predicate<String> valuePredicate) {
        return this.getHeaders().containsHeaderString(name, valueSeparatorRegex, valuePredicate);
    }

    public boolean containsHeaderString(String name, Predicate<String> valuePredicate) {
        return this.getHeaders().containsHeaderString(name, valuePredicate);
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.getHeaders().getRequestHeaders();
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return this.getHeaders().getAcceptableMediaTypes();
    }

    public List<Locale> getAcceptableLanguages() {
        return this.getHeaders().getAcceptableLanguages();
    }

    public MediaType getMediaType() {
        return this.getHeaders().getMediaType();
    }

    public Locale getLanguage() {
        return this.getHeaders().getLanguage();
    }

    public Map<String, Cookie> getCookies() {
        return this.getHeaders().getCookies();
    }

    public Date getDate() {
        return this.getHeaders().getDate();
    }

    public int getLength() {
        return this.getHeaders().getLength();
    }
}

