/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.container;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.Order;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.NotAcceptableException;
import io.micronaut.http.server.exceptions.UnsupportedMediaException;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.jaxrs.common.JaxRsMutableResponse;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Providers;

@Singleton
@Produces
@Internal
@Order(value=-2147483648)
final class JaxRsHttpStatusExceptionHandler
implements ExceptionHandler<HttpStatusException, HttpResponse<?>> {
    private final ErrorResponseProcessor<?> responseProcessor;
    private final Providers providers;

    @Inject
    JaxRsHttpStatusExceptionHandler(ErrorResponseProcessor<?> responseProcessor, Providers providers) {
        this.responseProcessor = responseProcessor;
        this.providers = providers;
    }

    public HttpResponse<?> handle(HttpRequest request, HttpStatusException exception) {
        WebApplicationException webApplicationException = this.remap(exception);
        if (webApplicationException != null) {
            ExceptionMapper exceptionMapper = this.providers.getExceptionMapper(webApplicationException.getClass());
            Response response = exceptionMapper != null ? exceptionMapper.toResponse((Throwable)webApplicationException) : webApplicationException.getResponse();
            return ((JaxRsMutableResponse)response).getResponse();
        }
        return this.responseProcessor.processResponse(ErrorContext.builder((HttpRequest)request).errorMessage(exception.getMessage()).cause((Throwable)exception).build(), HttpResponse.badRequest());
    }

    @Nullable
    private WebApplicationException remap(HttpStatusException exception) {
        if (exception instanceof NotAcceptableException) {
            NotAcceptableException notAcceptableException = (NotAcceptableException)exception;
            return new jakarta.ws.rs.NotAcceptableException(notAcceptableException.getMessage(), (Throwable)exception);
        }
        if (exception instanceof io.micronaut.http.server.exceptions.NotFoundException) {
            io.micronaut.http.server.exceptions.NotFoundException notFoundException = (io.micronaut.http.server.exceptions.NotFoundException)exception;
            return new NotFoundException(notFoundException.getMessage(), (Throwable)notFoundException);
        }
        if (exception instanceof UnsupportedMediaException) {
            UnsupportedMediaException notSupportedException = (UnsupportedMediaException)exception;
            return new NotSupportedException(notSupportedException.getMessage(), (Throwable)notSupportedException);
        }
        return null;
    }
}

