/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.container;

import io.micronaut.context.BeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.qualifiers.MatchArgumentQualifier;
import jakarta.inject.Singleton;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;

@Internal
@Singleton
final class JaxRsProviders
implements Providers {
    private final BeanContext beanContext;

    JaxRsProviders(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Collection messageBodyReaders = this.beanContext.getBeansOfType(Argument.of(MessageBodyReader.class, (Argument[])new Argument[]{Argument.of(type)}));
        return messageBodyReaders.stream().filter(r -> r.isReadable(type, genericType, annotations, mediaType)).findFirst().map(r -> new MessageBodyReader<T>(){
            final /* synthetic */ MessageBodyReader val$r;
            final /* synthetic */ Type val$genericType;
            final /* synthetic */ Annotation[] val$annotations;
            final /* synthetic */ MediaType val$mediaType;
            {
                this.val$r = messageBodyReader;
                this.val$genericType = type;
                this.val$annotations = annotationArray;
                this.val$mediaType = mediaType;
            }

            public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
                return true;
            }

            public T readFrom(Class<T> type, Type ignore1, Annotation[] ignore2, MediaType ignore3, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
                return this.val$r.readFrom(type, this.val$genericType, this.val$annotations, this.val$mediaType, httpHeaders, entityStream);
            }
        }).orElse(null);
    }

    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Collection messageBodyWriters = this.beanContext.getBeansOfType(Argument.of(MessageBodyWriter.class, (Argument[])new Argument[]{Argument.of(type)}));
        return messageBodyWriters.stream().filter(w -> w.isWriteable(type, genericType, annotations, mediaType)).findFirst().map(w -> new MessageBodyWriter<T>(){
            final /* synthetic */ MessageBodyWriter val$w;
            final /* synthetic */ Class val$type;
            final /* synthetic */ Type val$genericType;
            final /* synthetic */ Annotation[] val$annotations;
            final /* synthetic */ MediaType val$mediaType;
            {
                this.val$w = messageBodyWriter;
                this.val$type = clazz;
                this.val$genericType = type;
                this.val$annotations = annotationArray;
                this.val$mediaType = mediaType;
            }

            public boolean isWriteable(Class<?> ignore1, Type ignore2, Annotation[] ignore3, MediaType ignore4) {
                return true;
            }

            public long getSize(T t, Class<?> ignore1, Type ignore2, Annotation[] ignore3, MediaType ignore4) {
                return this.val$w.getSize(t, this.val$type, this.val$genericType, this.val$annotations, this.val$mediaType);
            }

            public void writeTo(T t, Class<?> ignore1, Type ignore2, Annotation[] ignore3, MediaType ignore4, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
                this.val$w.writeTo(t, this.val$type, this.val$genericType, this.val$annotations, this.val$mediaType, httpHeaders, entityStream);
            }
        }).orElse(null);
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        return this.beanContext.getBeansOfType(ExceptionMapper.class, (Qualifier)MatchArgumentQualifier.contravariant(ExceptionMapper.class, (Argument)Argument.of(type))).stream().findFirst().orElse(null);
    }

    private Argument<?> getExceptionType(BeanDefinition<ExceptionMapper> definition) {
        List args = definition.getTypeArguments(ExceptionMapper.class);
        return args.isEmpty() ? null : (Argument)args.get(0);
    }

    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        return null;
    }
}

