/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jaxrs.runtime.ext.bind;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.jaxrs.container.ApplicationPathProvider;
import io.micronaut.jaxrs.runtime.ext.bind.UriInfoImpl;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.UriInfo;
import java.util.Optional;

@Singleton
@Internal
public final class UriInfoBinder
implements TypedRequestArgumentBinder<UriInfo> {
    private static final Argument<UriInfo> ARGUMENT = Argument.of(UriInfo.class);
    private final ApplicationPathProvider applicationPathProvider;

    public UriInfoBinder(ApplicationPathProvider applicationPathProvider) {
        this.applicationPathProvider = applicationPathProvider;
    }

    public ArgumentBinder.BindingResult<UriInfo> bind(ArgumentConversionContext<UriInfo> uriInfo, HttpRequest<?> source) {
        return () -> Optional.of(new UriInfoImpl(source, this.applicationPathProvider.getPath()));
    }

    public Argument<UriInfo> argumentType() {
        return ARGUMENT;
    }
}

