/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jms.activemq.artemis.configuration;

import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.StringUtils;
import io.micronaut.jms.activemq.artemis.configuration.properties.ActiveMqArtemisConfigurationProperties;
import io.micronaut.jms.annotations.JMSConnectionFactory;
import javax.jms.ConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
@Requires(property="micronaut.jms.activemq.artemis.enabled", value="true")
public class ActiveMqArtemisConfiguration {
    public static final String CONNECTION_FACTORY_BEAN_NAME = "activeMqArtemisConnectionFactory";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @JMSConnectionFactory(value="activeMqArtemisConnectionFactory")
    public ConnectionFactory activeMqArtemisConnectionFactory(ActiveMqArtemisConfigurationProperties config) {
        this.logger.debug("created ConnectionFactory bean '{}' (ActiveMQJMSConnectionFactory) for broker URL '{}'", (Object)CONNECTION_FACTORY_BEAN_NAME, (Object)config.getConnectionString());
        String username = config.getUsername();
        String password = config.getPassword();
        if (StringUtils.isNotEmpty((CharSequence)username) || StringUtils.isNotEmpty((CharSequence)password)) {
            return new ActiveMQJMSConnectionFactory(config.getConnectionString(), username, password);
        }
        return new ActiveMQJMSConnectionFactory(config.getConnectionString());
    }
}

