/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jms.sqs.configuration;

import com.amazon.sqs.javamessaging.ProviderConfiguration;
import com.amazon.sqs.javamessaging.SQSConnectionFactory;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.jms.annotations.JMSConnectionFactory;
import io.micronaut.jms.sqs.configuration.properties.SqsConfigurationProperties;
import javax.jms.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;

@Factory
@Requires(property="micronaut.jms.sqs.enabled", value="true")
public class SqsConfiguration {
    public static final String CONNECTION_FACTORY_BEAN_NAME = "sqsJmsConnectionFactory";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @JMSConnectionFactory(value="sqsJmsConnectionFactory")
    public ConnectionFactory sqsJmsConnectionFactory(SqsConfigurationProperties config, SqsClient sqs) {
        this.logger.debug("created ConnectionFactory bean '{}' (SQSConnectionFactory)", (Object)CONNECTION_FACTORY_BEAN_NAME);
        return new SQSConnectionFactory(new ProviderConfiguration().withNumberOfMessagesToPrefetch(config.getNumberOfMessagesToPrefetch().intValue()), sqs);
    }

    @JMSConnectionFactory(value="sqsJmsConnectionFactory")
    public ConnectionFactory sqsJmsConnectionFactory(SqsConfigurationProperties config, SqsClientBuilder builder) {
        this.logger.debug("created ConnectionFactory bean '{}' (SQSConnectionFactory)", (Object)CONNECTION_FACTORY_BEAN_NAME);
        return new SQSConnectionFactory(new ProviderConfiguration().withNumberOfMessagesToPrefetch(config.getNumberOfMessagesToPrefetch().intValue()), builder);
    }
}

