/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.type.SimpleType;
import io.micronaut.core.annotation.Internal;
import io.micronaut.jsonschema.model.Schema;
import java.io.IOException;
import java.util.Collections;

@Internal
public class JsonSchemaMapperFactory {
    public static ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        mapper.configure(SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN, true);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Schema.class, (JsonSerializer)new SchemaSerializer());
        module.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                if (beanDesc.getBeanClass() == Schema.class) {
                    return new SchemaDeserializer(deserializer);
                }
                return deserializer;
            }
        });
        mapper.registerModule((Module)module);
        return mapper;
    }

    static class SchemaSerializer
    extends JsonSerializer<Schema> {
        SchemaSerializer() {
        }

        public void serialize(Schema schema, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            if (schema == Schema.TRUE) {
                jsonGenerator.writeBoolean(true);
            } else if (schema == Schema.FALSE) {
                jsonGenerator.writeBoolean(false);
            } else {
                BeanSerializerFactory.instance.createSerializer(provider, (JavaType)SimpleType.construct(Schema.class)).serialize((Object)schema, jsonGenerator, provider);
            }
        }
    }

    static class SchemaDeserializer
    extends DelegatingDeserializer {
        public SchemaDeserializer(JsonDeserializer delegate) {
            super(delegate);
        }

        protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> delegate) {
            return new SchemaDeserializer(delegate);
        }

        public Schema deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException, JacksonException {
            JsonNode tree = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            jsonParser.finishToken();
            if (tree instanceof ObjectNode) {
                ObjectNode node = (ObjectNode)tree;
                if (node.isEmpty()) {
                    return Schema.TRUE;
                }
                Object object = node.get("type");
                if (object instanceof TextNode) {
                    TextNode text = (TextNode)object;
                    node.set("type", (JsonNode)new ArrayNode(context.getNodeFactory(), Collections.singletonList(text)));
                }
                try (TreeTraversingParser newParser = new TreeTraversingParser(tree, jsonParser.getCodec());){
                    newParser.nextToken();
                    object = (Schema)this.getDelegatee().deserialize((JsonParser)newParser, context);
                    return object;
                }
            }
            if (tree instanceof BooleanNode) {
                BooleanNode bool = (BooleanNode)tree;
                return bool.asBoolean() ? Schema.TRUE : Schema.FALSE;
            }
            return null;
        }
    }
}

