/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.generator.utils;

import io.micronaut.core.annotation.Internal;
import io.micronaut.jsonschema.generator.SourceGenerator;
import io.micronaut.jsonschema.generator.aggregator.AnnotationsAggregator;
import io.micronaut.jsonschema.generator.aggregator.TypeAggregator;
import io.micronaut.jsonschema.model.Schema;
import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public final class GeneratorContext {
    private final HashMap<String, Map.Entry<TypeDef, Boolean>> DEFINITIONS = new HashMap();
    private final HashMap<String, LinkedList<String>> TEMP_DEFINITIONS = new HashMap();
    private final HashMap<String, Schema> ONE_OF_SET = new HashMap();

    public boolean isDefinitionClass(String key) {
        return this.getDefinition(key).getValue();
    }

    public TypeDef getDefinitionType(String key) {
        return this.getDefinition(key).getKey();
    }

    private Map.Entry<TypeDef, Boolean> getDefinition(String key) {
        String defKey = this.unifyKey(key);
        if (this.hasDefinition(defKey)) {
            return this.DEFINITIONS.get(defKey);
        }
        throw new IllegalArgumentException("Definition not found: " + key);
    }

    public List<Map.Entry<String, Schema>> getOneOfsToGenerate() {
        return this.ONE_OF_SET.entrySet().stream().filter(entry -> entry.getValue() != null).toList();
    }

    public boolean hasDefinition(String key) {
        return this.DEFINITIONS.containsKey(key);
    }

    public boolean isInheriting(String className) {
        String key = SourceGenerator.getInputFileName() + "#/oneOf/" + className;
        String keyRef = SourceGenerator.getInputFileName() + "#/$defs/" + className;
        return this.ONE_OF_SET.containsKey(key) || this.ONE_OF_SET.containsKey(keyRef);
    }

    public void addDefinition(String key, Schema definition) {
        String unifiedKey = this.unifyKey(key);
        if (definition.hasOneOf()) {
            this.addDefinition(unifiedKey, (TypeDef)TypeDef.OBJECT, definition.hasProperties());
        } else if (definition.has$ref()) {
            String referredKey = this.unifyKey(SourceGenerator.getInputFileName() + definition.get$ref());
            if (!this.hasDefinition(referredKey)) {
                this.addTempDefinition(unifiedKey, referredKey);
            } else {
                Map.Entry<TypeDef, Boolean> entry = this.getDefinition(referredKey);
                this.addDefinition(unifiedKey, entry.getKey(), entry.getValue());
            }
        } else {
            boolean isClass;
            TypeDef typeDef = TypeAggregator.getTypeDefFromJson(definition, this);
            assert (typeDef != null);
            boolean bl = isClass = !typeDef.isPrimitive() && !typeDef.equals(TypeDef.STRING) && !typeDef.equals(ClassTypeDef.of(Float.class)) && !typeDef.equals(ClassTypeDef.of(Integer.class)) && !typeDef.equals(TypeDef.of(List.class));
            if (isClass) {
                typeDef = ClassTypeDef.of((String)TypeAggregator.getClassName(unifiedKey.substring(unifiedKey.lastIndexOf(47) + 1)));
            } else if (typeDef.equals(TypeDef.of(List.class))) {
                typeDef = this.getListTypeDef(definition, typeDef);
            }
            List<AnnotationDef> annotations = AnnotationsAggregator.getAnnotations(definition, typeDef, false);
            if (!annotations.isEmpty()) {
                typeDef = typeDef.annotated(annotations);
            }
            this.addDefinition(unifiedKey, typeDef, isClass);
        }
    }

    private TypeDef getListTypeDef(Schema definition, TypeDef typeDef) {
        Schema items;
        Schema schema = items = definition.getItems() != null ? definition.getItems() : definition.getContains();
        if (items == null) {
            return TypeDef.OBJECT;
        }
        TypeDef innerType = TypeAggregator.getTypeDefFromJson(items, this);
        if (innerType instanceof TypeDef.Primitive) {
            TypeDef.Primitive primitive = (TypeDef.Primitive)innerType;
            innerType = primitive.wrapperType();
        } else if (innerType.equals(TypeDef.of(List.class))) {
            innerType = this.getListTypeDef(items, innerType);
        }
        List<AnnotationDef> annotations = AnnotationsAggregator.getAnnotations(items, innerType, false);
        if (!annotations.isEmpty()) {
            innerType = innerType.annotated(annotations);
        }
        typeDef = TypeDef.parameterized(definition.isUniqueItems() != null && definition.isUniqueItems() != false ? Set.class : List.class, (TypeDef[])new TypeDef[]{innerType});
        return typeDef;
    }

    public void addDefinition(String key, TypeDef classDef, boolean isClass) {
        AbstractMap.SimpleEntry<TypeDef, Boolean> newDef = new AbstractMap.SimpleEntry<TypeDef, Boolean>(classDef, isClass);
        String defKey = this.unifyKey(key);
        if (!this.hasDefinition(defKey)) {
            this.DEFINITIONS.put(defKey, newDef);
        } else {
            this.DEFINITIONS.replace(defKey, newDef);
        }
        if (this.TEMP_DEFINITIONS.containsKey(defKey)) {
            this.TEMP_DEFINITIONS.get(defKey).forEach(ref -> this.DEFINITIONS.put((String)ref, (Map.Entry<TypeDef, Boolean>)newDef));
        }
    }

    public void addTempDefinition(String referringDef, String ref) {
        String referringKey = this.unifyKey(referringDef);
        String referredKey = this.unifyKey(ref);
        if (this.TEMP_DEFINITIONS.containsKey(referredKey)) {
            LinkedList<String> tempList = this.TEMP_DEFINITIONS.get(referredKey);
            tempList.add(referringKey);
            this.TEMP_DEFINITIONS.replace(referredKey, tempList);
        } else {
            this.TEMP_DEFINITIONS.put(referredKey, new LinkedList<String>(List.of(referringKey)));
        }
    }

    public void addOneOf(String key) {
        this.ONE_OF_SET.put(this.unifyKey(key), null);
    }

    public void addOneOf(Schema oneOf) {
        String fileName = SourceGenerator.getInputFileName();
        Object className = oneOf.hasTitle() ? TypeAggregator.getClassName(oneOf.getTitle()) : "Option" + this.ONE_OF_SET.size();
        this.ONE_OF_SET.put(fileName + "#/oneOf/" + (String)className, oneOf);
        this.addDefinition(fileName + "#/oneOf/" + (String)className, (TypeDef)ClassTypeDef.of((String)TypeAggregator.getClassName((String)className)), true);
    }

    public void clearAll() {
        this.DEFINITIONS.clear();
        this.ONE_OF_SET.clear();
        this.TEMP_DEFINITIONS.clear();
    }

    private String unifyKey(String key) {
        if (!key.contains("#/definitions/")) {
            return key;
        }
        return key.replace("#/definitions/", "#/$defs/");
    }
}

