/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.generator.loaders;

import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.jsonschema.generator.SourceGenerator;
import io.micronaut.jsonschema.generator.aggregator.TypeAggregator;
import io.micronaut.jsonschema.generator.loaders.FileLoader;
import io.micronaut.jsonschema.generator.loaders.SchemaLoader;
import io.micronaut.jsonschema.generator.loaders.StreamLoader;
import io.micronaut.jsonschema.generator.loaders.UrlLoader;
import io.micronaut.jsonschema.generator.utils.SourceGeneratorConfig;
import io.micronaut.jsonschema.model.Schema;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;

@Internal
public class FileProcessor {
    public static Schema getJsonSchema(SourceGeneratorConfig config) {
        try {
            SchemaLoader loader;
            if (config.inputStream() != null) {
                loader = new StreamLoader(config.inputStream());
            } else if (config.jsonUrl() != null && !config.jsonUrl().isBlank()) {
                loader = new UrlLoader(config.jsonUrl());
            } else if (config.jsonFile() != null) {
                loader = new FileLoader(config.jsonFile());
            } else {
                throw new RuntimeException("Missing required config.jsonUrl(), config.inputStream(), or config.jsonFile().");
            }
            return loader.load();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error loading JSON schema", e);
        }
    }

    public static File getOutputFile(Path outputPath, String packageName, String fileName) throws IOException {
        String packagePath = packageName.replace('.', File.separatorChar);
        Path fullPath = outputPath.resolve(packagePath).resolve(fileName);
        File outputFile = fullPath.toFile();
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        if (!outputFile.exists() && !outputFile.createNewFile()) {
            throw new IOException("Could not create file " + outputFile.getAbsolutePath());
        }
        return outputFile;
    }

    public static String getFileName(Schema schema, Optional<String> topLevelName) {
        if (topLevelName.isPresent() && !topLevelName.get().isEmpty()) {
            fileName = topLevelName.get();
            if (((String)fileName).contains("http")) {
                fileName = ((String)fileName).substring(((String)fileName).lastIndexOf(47) + 1);
            }
        } else {
            fileName = schema.hasTitle() ? TypeAggregator.getClassName(schema.getTitle()) : "SchemaFile";
        }
        Object fileName = switch (SourceGenerator.getLanguage()) {
            case VisitorContext.Language.KOTLIN -> (String)fileName + ".kt";
            case VisitorContext.Language.GROOVY -> (String)fileName + ".groovy";
            default -> (String)fileName + ".java";
        };
        return fileName;
    }
}

