/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.generator.aggregator;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.jsonschema.generator.SourceGenerator;
import io.micronaut.jsonschema.generator.utils.GeneratorContext;
import io.micronaut.jsonschema.model.Schema;
import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Internal
public class AnnotationsAggregator {
    public static final String SERDEABLE_ANN = "io.micronaut.serde.annotation.Serdeable";
    private static final String JACKSON_VALIDATION_PREFIX = "com.fasterxml.jackson.annotation.";
    public static final String JSON_ANY_GETTER_ANN = "com.fasterxml.jackson.annotation.JsonAnyGetter";
    public static final String JSON_ANY_SETTER_ANN = "com.fasterxml.jackson.annotation.JsonAnySetter";
    public static final String JSON_CREATOR_ANN = "com.fasterxml.jackson.annotation.JsonCreator";
    public static final String JSON_VALUE_ANN = "com.fasterxml.jackson.annotation.JsonValue";
    private static final String JSON_PROPERTY_ANN = "com.fasterxml.jackson.annotation.JsonProperty";
    private static final String JSON_SUB_TYPES_ANN = "com.fasterxml.jackson.annotation.JsonSubTypes";
    private static final String JSON_SUB_TYPES_TYPE_ANN = "com.fasterxml.jackson.annotation.JsonSubTypes.Type";
    private static final String JSON_TYPE_INFO_ANN = "com.fasterxml.jackson.annotation.JsonTypeInfo";
    private static final String NULLABLE_ANN = "jakarta.annotation.Nullable";
    private static final String JAKARTA_VALIDATION_PREFIX = "jakarta.validation.constraints.";
    public static final String NOT_NULL_ANN = "jakarta.validation.constraints.NotNull";
    private static final String ASSERT_FALSE_ANN = "jakarta.validation.constraints.AssertFalse";
    private static final String ASSERT_TRUE_ANN = "jakarta.validation.constraints.AssertTrue";
    private static final String SIZE_ANN = "jakarta.validation.constraints.Size";
    private static final String MIN_ANN = "jakarta.validation.constraints.Min";
    private static final String MAX_ANN = "jakarta.validation.constraints.Max";
    private static final String DECIMAL_MIN_ANN = "jakarta.validation.constraints.DecimalMin";
    private static final String DECIMAL_MAX_ANN = "jakarta.validation.constraints.DecimalMax";
    private static final String PATTERN_ANN = "jakarta.validation.constraints.Pattern";
    private static final String EMAIL_ANN = "jakarta.validation.constraints.Email";
    private static final int EXCLUSIVE_DELTA_INT = 1;
    private static final double EXCLUSIVE_DELTA_DOUBLE = 0.001;

    public static AnnotationDef getJsonTypeInfoAnn(String propertyName) {
        return AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)JSON_TYPE_INFO_ANN)).addMember("use", (Object)JsonTypeInfo.Id.NAME).addMember("property", (Object)propertyName).build();
    }

    public static AnnotationDef getJsonPropertyAnn(String propertyName) {
        return AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)JSON_PROPERTY_ANN)).addMember("value", (Object)propertyName).build();
    }

    public static AnnotationDef getJsonSubTypesAnn(Map<String, String> mapping, GeneratorContext context) {
        List<AnnotationDef> subTypeList = mapping.entrySet().stream().map(entry -> AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)JSON_SUB_TYPES_TYPE_ANN)).addMember("value", (Object)context.getDefinitionType(SourceGenerator.getInputFileName() + (String)entry.getValue())).addMember("name", entry.getKey()).build()).toList();
        return AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)JSON_SUB_TYPES_ANN)).addMember("value", subTypeList).build();
    }

    public static List<AnnotationDef> getAnnotations(Schema schema, TypeDef propertyType, boolean required) {
        Object value;
        String maxAnn;
        ArrayList<AnnotationDef> annotations = new ArrayList<AnnotationDef>();
        boolean isFloat = propertyType.equals(TypeDef.Primitive.FLOAT) || propertyType.equals(ClassTypeDef.of(Float.class));
        String minAnn = isFloat ? DECIMAL_MIN_ANN : MIN_ANN;
        String string = maxAnn = isFloat ? DECIMAL_MAX_ANN : MAX_ANN;
        if (required) {
            annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)NOT_NULL_ANN)).build());
        }
        if (schema.isNullable() != null) {
            String nullableAnn = schema.isNullable() != false ? NULLABLE_ANN : NOT_NULL_ANN;
            annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)nullableAnn)).build());
        }
        if (schema.getMinimum() != null) {
            value = schema.getMinimum();
            annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)minAnn)).addMember("value", isFloat ? String.valueOf(value) : value).build());
        }
        if (schema.getMaximum() != null) {
            value = schema.getMaximum();
            annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)maxAnn)).addMember("value", isFloat ? String.valueOf(value) : value).build());
        }
        if (schema.getExclusiveMinimum() != null) {
            value = schema.getExclusiveMinimum();
            annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)minAnn)).addMember("value", isFloat ? "" + ((Double)value + 0.001) : Integer.valueOf((Integer)value + 1)).build());
        }
        if (schema.getExclusiveMaximum() != null) {
            value = schema.getExclusiveMaximum();
            annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)maxAnn)).addMember("value", isFloat ? "" + ((Double)value - 0.001) : Integer.valueOf((Integer)value - 1)).build());
        }
        if (schema.getMaxLength() != null || schema.getMaxItems() != null || schema.getMaxContains() != null) {
            value = schema.getMaxLength() != null ? schema.getMaxLength() : schema.getMaxItems();
            value = value == null ? schema.getMaxContains() : value;
            annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)SIZE_ANN)).addMember("max", value).build());
        }
        if (schema.getMinLength() != null || schema.getMinItems() != null || schema.getMinContains() != null) {
            value = schema.getMinLength() != null ? schema.getMinLength() : schema.getMinItems();
            value = value == null ? schema.getMinContains() : value;
            annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)SIZE_ANN)).addMember("min", value).build());
        }
        if (schema.getPattern() != null && propertyType.equals(TypeDef.STRING)) {
            value = schema.getPattern();
            if (SourceGenerator.getLanguage().equals((Object)VisitorContext.Language.GROOVY)) {
                value = ((String)value).replaceAll("\\$", "");
            }
            annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)PATTERN_ANN)).addMember("regexp", value).build());
        }
        if (schema.getPattern() != null && (propertyType.equals(ClassTypeDef.of(Float.class)) || propertyType.equals(ClassTypeDef.of(Integer.class)) || propertyType.equals(TypeDef.Primitive.INT) || propertyType.equals(TypeDef.Primitive.FLOAT))) {
            String pattern;
            switch (pattern = schema.getPattern()) {
                case "^[1-9][0-9]*$": {
                    annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)MIN_ANN)).addMember("value", (Object)1).build());
                    break;
                }
                case "^\\d*.?\\d+$": 
                case "^[1-9][0-9]*.?[0-9]+$": {
                    annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)DECIMAL_MIN_ANN)).addMember("value", (Object)"0.001").build());
                    break;
                }
                case "^[0-9]*$": 
                case "^[0]|([1-9][0-9]*)$": {
                    annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)MIN_ANN)).addMember("value", (Object)0).build());
                    break;
                }
                case "^-d+$": 
                case "^-[1-9][0-9]*$": {
                    annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)MAX_ANN)).addMember("value", (Object)0).build());
                    break;
                }
                case "^-d*.?d+$": 
                case "^-[1-9][0-9]*.?[0-9]+$": {
                    annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)DECIMAL_MAX_ANN)).addMember("value", (Object)"-0.001").build());
                    break;
                }
                case "^(-d+(.d+)?|0(.0+)?)$": 
                case "^-?(0|[1-9][0-9]{0,17})(.[0-9]{1,17})?([eE][+-]?[0-9]{1,9}})?$": {
                    annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)MAX_ANN)).addMember("value", (Object)0).build());
                    break;
                }
                case "^[0]|[-+]?[1-9][0-9]*$": {
                    break;
                }
                default: {
                    System.err.println("Unsupported validation pattern for number: " + pattern);
                }
            }
        }
        if (schema.getFormat() != null && schema.getFormat().equals("email")) {
            annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)EMAIL_ANN)).build());
        }
        if (schema.getConstValue() != null && propertyType.equals(TypeDef.Primitive.BOOLEAN)) {
            if (schema.getConstValue().toString().equals("true")) {
                annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)ASSERT_TRUE_ANN)).build());
            } else if (schema.getConstValue().toString().equals("false")) {
                annotations.add(AnnotationDef.builder((ClassTypeDef)ClassTypeDef.of((String)ASSERT_FALSE_ANN)).build());
            }
        }
        return annotations;
    }
}

