/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.visitor.aggregator;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonEnumDefaultValue;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.annotation.JsonKey;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonView;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.jsonschema.model.Schema;
import io.micronaut.jsonschema.visitor.JsonSchemaVisitor;
import io.micronaut.jsonschema.visitor.aggregator.SchemaInfoAggregator;
import io.micronaut.jsonschema.visitor.aggregator.ValidationInfoAggregator;
import io.micronaut.jsonschema.visitor.context.JsonSchemaContext;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Internal
public class JacksonInfoAggregator
implements SchemaInfoAggregator {
    public static final List<Class<? extends Annotation>> UNSUPPORTED_ANNOTATIONS = List.of(JsonAlias.class, JsonAutoDetect.class, JsonBackReference.class, JsonCreator.class, JsonEnumDefaultValue.class, JsonFormat.class, JsonIdentityInfo.class, JsonIdentityReference.class, JsonKey.class, JsonManagedReference.class, JsonRawValue.class, JsonRootName.class, JsonTypeId.class, JsonValue.class, JsonView.class, JsonFilter.class);

    @Override
    public Schema addInfo(TypedElement element, Schema schema, VisitorContext visitorContext, JsonSchemaContext context) {
        ClassElement type = element.getGenericType();
        UNSUPPORTED_ANNOTATIONS.stream().filter(arg_0 -> ((TypedElement)element).hasAnnotation(arg_0)).forEach(ann -> visitorContext.warn("Could not add annotation " + String.valueOf(ann) + " to schema as it is not supported by the JacksonInfoAggregator", (Element)element));
        this.addSubtypeInfo(type, schema, visitorContext, context);
        this.addPropertyInfo(type, schema, visitorContext, context);
        return schema;
    }

    private void addPropertyInfo(ClassElement element, Schema schema, VisitorContext visitorContext, JsonSchemaContext context) {
        if (element.hasAnnotation(JsonClassDescription.class)) {
            schema.setDescription((String)element.stringValue(JsonClassDescription.class).orElse(null));
        }
        Set includeProperties = null;
        Set ignoreProperties = null;
        if (element.hasAnnotation(JsonIncludeProperties.class)) {
            includeProperties = Arrays.stream(element.stringValues(JsonIncludeProperties.class)).collect(Collectors.toSet());
        }
        if (element.hasAnnotation(JsonIgnoreProperties.class)) {
            ignoreProperties = Arrays.stream(element.stringValues(JsonIgnoreProperties.class)).collect(Collectors.toSet());
        }
        if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
            for (PropertyElement property : element.getBeanProperties()) {
                Schema propertySchema = (Schema)schema.getProperties().get(property.getName());
                if (propertySchema == null) continue;
                String name = property.stringValue(JsonProperty.class).orElse(property.stringValue(JsonGetter.class).orElse(property.stringValue(JsonSetter.class).orElse(property.getName())));
                if (property.hasAnnotation(JsonIgnore.class) || property.getGenericType().hasAnnotation(JsonIgnoreType.class) || ignoreProperties != null && ignoreProperties.contains(name)) {
                    schema.getProperties().remove(property.getName());
                    continue;
                }
                if (includeProperties != null && !includeProperties.contains(name) && !property.hasAnnotation(JsonInclude.class)) {
                    schema.getProperties().remove(property.getName());
                    continue;
                }
                if (property.hasAnnotation(JsonAnyGetter.class) || property.hasAnnotation(JsonAnySetter.class)) {
                    if (!property.getType().isAssignable(Map.class)) {
                        visitorContext.fail("Property annotated with @JsonAnyGetter must be of type Map", (Element)property);
                    }
                    schema.getProperties().remove(property.getName());
                    schema.setAdditionalProperties(propertySchema.getAdditionalProperties());
                }
                property.stringValue(JsonPropertyDescription.class).ifPresent(arg_0 -> ((Schema)propertySchema).setDescription(arg_0));
                if (property.hasAnnotation(JsonUnwrapped.class)) {
                    schema.getProperties().remove(property.getName());
                    schema.getProperties().putAll(propertySchema.getProperties());
                } else if (!name.equals(property.getName())) {
                    schema.getProperties().remove(property.getName());
                    schema.putProperty(name, propertySchema);
                }
                ValidationInfoAggregator.addRequiredPropertyInfo(name, property, schema, context);
            }
        }
        for (MethodElement method : element.getMethods()) {
            if (!method.hasAnnotation(JsonAnySetter.class) || method.getParameters().length != 2) continue;
            schema.setAdditionalProperties(JsonSchemaVisitor.createSchema((TypedElement)method.getParameters()[1], visitorContext, context));
        }
    }

    private void addSubtypeInfo(ClassElement element, Schema schema, VisitorContext visitorContext, JsonSchemaContext context) {
        AnnotationValue subTypesAnn = element.getAnnotation(JsonSubTypes.class);
        AnnotationValue typeInfoAnn = element.getAnnotation(JsonTypeInfo.class);
        if (subTypesAnn == null || typeInfoAnn == null) {
            return;
        }
        JsonTypeInfo.Id id = typeInfoAnn.enumValue("use", JsonTypeInfo.Id.class).orElse(JsonTypeInfo.Id.NAME);
        JsonTypeInfo.As as = typeInfoAnn.enumValue("include", JsonTypeInfo.As.class).orElse(JsonTypeInfo.As.PROPERTY);
        String discriminatorName = typeInfoAnn.stringValue("property").orElse(id.getDefaultPropertyName());
        for (AnnotationValue subTypeAnn : subTypesAnn.getAnnotations("value", JsonSubTypes.Type.class)) {
            ClassElement subType = subTypeAnn.stringValue().flatMap(arg_0 -> ((VisitorContext)visitorContext).getClassElement(arg_0)).orElse(null);
            if (subType == null) continue;
            Schema subTypeSchema = JsonSchemaVisitor.createSchema((TypedElement)subType, visitorContext, context);
            if (discriminatorName != null) {
                String discriminatorValue = null;
                if (id == JsonTypeInfo.Id.MINIMAL_CLASS) {
                    discriminatorValue = this.getMinimalClassName(element.getPackageName(), subType.getName());
                } else if (id == JsonTypeInfo.Id.NAME) {
                    if (subTypeAnn.stringValues("names").length != 0) {
                        subTypeSchema.putProperty(discriminatorName, Schema.string().setEnumValues(Arrays.stream(subTypeAnn.stringValues("names")).map(v -> v).toList()));
                    } else {
                        discriminatorValue = subTypeAnn.stringValue("name").orElse(subType.stringValue(JsonTypeName.class).orElse(subType.getSimpleName()));
                    }
                } else {
                    discriminatorValue = subType.getName();
                }
                if (discriminatorValue != null) {
                    if (as == JsonTypeInfo.As.PROPERTY || as == JsonTypeInfo.As.EXISTING_PROPERTY) {
                        subTypeSchema.putProperty(discriminatorName, Schema.string().setConstValue((Object)discriminatorValue)).addRequired(discriminatorName);
                    } else if (as == JsonTypeInfo.As.WRAPPER_OBJECT) {
                        subTypeSchema = Schema.object().putProperty(discriminatorValue, subTypeSchema);
                    } else {
                        visitorContext.warn("@JsonTypeInfo(include = " + String.valueOf(as) + ") is not supported", (Element)element);
                    }
                }
            }
            schema.addOneOf(subTypeSchema);
        }
    }

    private String getMinimalClassName(String parentClassPackage, String className) {
        if (className.startsWith(parentClassPackage)) {
            return className.substring(parentClassPackage.length());
        }
        return className;
    }
}

