/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.visitor.aggregator;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.JavadocBlockTag;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.jsonschema.model.Schema;
import io.micronaut.jsonschema.visitor.aggregator.SchemaInfoAggregator;
import io.micronaut.jsonschema.visitor.context.JsonSchemaContext;
import java.util.HashMap;
import java.util.Optional;

@Internal
public class DocumentationInfoAggregator
implements SchemaInfoAggregator {
    @Override
    public Schema addInfo(TypedElement element, Schema schema, VisitorContext visitorContext, JsonSchemaContext context) {
        this.addElementDoc(element, schema, visitorContext);
        this.addRecordDocs(element.getGenericType(), schema, visitorContext);
        return schema;
    }

    private void addElementDoc(TypedElement element, Schema schema, VisitorContext visitorContext) {
        Optional documentation;
        block6: {
            block5: {
                if (element instanceof ClassElement && element.getGenericType().isRecord()) {
                    return;
                }
                documentation = element.getDocumentation();
                if (schema.getDescription() == null) break block5;
                if (element instanceof ClassElement) break block6;
            }
            documentation.ifPresent(arg_0 -> ((Schema)schema).setDescription(arg_0));
        }
        if (schema.getDescription() == null && documentation.isEmpty() && !(element instanceof ClassElement)) {
            documentation = element.getGenericType().getDocumentation();
            documentation.ifPresent(arg_0 -> ((Schema)schema).setDescription(arg_0));
        }
    }

    private void addRecordDocs(ClassElement element, Schema schema, VisitorContext visitorContext) {
        if (!element.isRecord()) {
            return;
        }
        String javadocString = element.getDocumentation().orElse(null);
        if (javadocString == null) {
            return;
        }
        Javadoc javadoc = StaticJavaParser.parseJavadoc((String)javadocString);
        if (schema.getDescription() == null && !javadoc.getDescription().isEmpty()) {
            schema.setDescription(javadoc.getDescription().toText());
        }
        HashMap propertiesDescription = new HashMap();
        for (JavadocBlockTag block : javadoc.getBlockTags()) {
            if (block.getType() != JavadocBlockTag.Type.PARAM) continue;
            block.getName().ifPresent(name -> propertiesDescription.put(name, block.getContent().toText()));
        }
        if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
            for (PropertyElement property : element.getBeanProperties()) {
                Schema propertySchema = (Schema)schema.getProperties().get(property.getName());
                if (propertySchema == null || !propertiesDescription.containsKey(property.getName())) continue;
                propertySchema.setDescription((String)propertiesDescription.get(property.getName()));
            }
        }
    }
}

