/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.visitor.aggregator;

import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.jsonschema.model.Schema;
import io.micronaut.jsonschema.visitor.aggregator.SchemaInfoAggregator;
import io.micronaut.jsonschema.visitor.context.JsonSchemaContext;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Internal
public class ValidationInfoAggregator
implements SchemaInfoAggregator {
    private static final String JAKARTA_ANNOTATION_PREFIX = "jakarta.annotation.";
    private static final String JAKARTA_VALIDATION_PREFIX = "jakarta.validation.constraints.";
    private static final String NULLABLE_ANN = "jakarta.annotation.Nullable";
    private static final String NON_NULL_ANN = "jakarta.annotation.Nonnull";
    private static final String NULL_ANN = "jakarta.validation.constraints.Null";
    private static final String ASSERT_FALSE_ANN = "jakarta.validation.constraints.AssertFalse";
    private static final String ASSERT_TRUE_ANN = "jakarta.validation.constraints.AssertTrue";
    private static final String NOT_EMPTY_ANN = "jakarta.validation.constraints.NotEmpty";
    private static final String NOT_NULL_ANN = "jakarta.validation.constraints.NotNull";
    private static final String SIZE_ANN = "jakarta.validation.constraints.Size";
    private static final String NOT_BLANK_ANN = "jakarta.validation.constraints.NotBlank";
    private static final String NEGATIVE_ANN = "jakarta.validation.constraints.Negative";
    private static final String NEGATIVE_OR_ZERO_ANN = "jakarta.validation.constraints.NegativeOrZero";
    private static final String POSITIVE_ANN = "jakarta.validation.constraints.Positive";
    private static final String POSITIVE_OR_ZERO_ANN = "jakarta.validation.constraints.PositiveOrZero";
    private static final String MIN_ANN = "jakarta.validation.constraints.Min";
    private static final String MAX_ANN = "jakarta.validation.constraints.Max";
    private static final String DECIMAL_MIN_ANN = "jakarta.validation.constraints.DecimalMin";
    private static final String DECIMAL_MAX_ANN = "jakarta.validation.constraints.DecimalMax";
    private static final String PATTERN_ANN = "jakarta.validation.constraints.Pattern";
    private static final String EMAIL_ANN = "jakarta.validation.constraints.Email";
    private static final String DIGITS_ANN = "jakarta.validation.constraints.Digits";
    private static final String FUTURE_ANN = "jakarta.validation.constraints.Future";
    private static final String FUTURE_OR_PRESENT_ANN = "jakarta.validation.constraints.FutureOrPresent";
    private static final String PAST_ANN = "jakarta.validation.constraints.Past";
    private static final String PAST_OR_PRESENT_ANN = "jakarta.validation.constraints.PastOrPresent";
    private static final String LIST_SUFFIX = "$List";
    public static final List<String> UNSUPPORTED_ANNOTATIONS = List.of("jakarta.validation.constraints.Future", "jakarta.validation.constraints.FutureOrPresent", "jakarta.validation.constraints.Past", "jakarta.validation.constraints.PastOrPresent");

    @Override
    public Schema addInfo(TypedElement element, Schema schema, VisitorContext visitorContext, JsonSchemaContext context) {
        UNSUPPORTED_ANNOTATIONS.stream().filter(ann -> element.hasAnnotation(ann + LIST_SUFFIX)).forEach(ann -> visitorContext.warn("Could not add annotation " + ann + " to schema as it is not supported by the JacksonInfoAggregator", (Element)element));
        ClassElement type = element.getGenericType();
        if (element.hasAnnotation("jakarta.validation.constraints.Null$List")) {
            schema.setType(List.of(Schema.Type.NULL));
        }
        if (schema.getType().contains(Schema.Type.BOOLEAN)) {
            if (element.hasAnnotation("jakarta.validation.constraints.AssertFalse$List")) {
                schema.setConstValue((Object)false);
            } else if (element.hasAnnotation("jakarta.validation.constraints.AssertTrue$List")) {
                schema.setConstValue((Object)true);
            }
        }
        if (type.isIterable() || type.isAssignable(Map.class)) {
            if (element.hasAnnotation("jakarta.validation.constraints.NotEmpty$List")) {
                schema.setMinItems(Integer.valueOf(1));
            }
            element.getAnnotationValuesByName(SIZE_ANN).forEach(ann -> {
                ann.intValue("min").ifPresent(arg_0 -> ((Schema)schema).setMinItems(arg_0));
                ann.intValue("max").ifPresent(arg_0 -> ((Schema)schema).setMaxItems(arg_0));
            });
        } else {
            if (element.hasAnnotation("jakarta.validation.constraints.NotBlank$List") || element.hasAnnotation("jakarta.validation.constraints.NotEmpty$List")) {
                schema.setMinLength(Integer.valueOf(1));
            }
            element.getAnnotationValuesByName(SIZE_ANN).forEach(ann -> {
                ann.intValue("min").ifPresent(arg_0 -> ((Schema)schema).setMinLength(arg_0));
                ann.intValue("max").ifPresent(arg_0 -> ((Schema)schema).setMaxLength(arg_0));
            });
            if (element.hasAnnotation("jakarta.validation.constraints.Negative$List")) {
                schema.setExclusiveMaximum((Object)0);
            }
            if (element.hasAnnotation("jakarta.validation.constraints.NegativeOrZero$List")) {
                schema.setMaximum((Object)0);
            }
            if (element.hasAnnotation("jakarta.validation.constraints.Positive$List")) {
                schema.setExclusiveMinimum((Object)0);
            }
            if (element.hasAnnotation("jakarta.validation.constraints.PositiveOrZero$List")) {
                schema.setMinimum((Object)0);
            }
            element.getAnnotationValuesByName(MIN_ANN).forEach(ann -> ann.intValue().ifPresent(v -> schema.setMinimum((Object)BigDecimal.valueOf(v))));
            element.getAnnotationValuesByName(MAX_ANN).forEach(ann -> ann.intValue().ifPresent(v -> schema.setMaximum((Object)BigDecimal.valueOf(v))));
            element.getAnnotationValuesByName(DECIMAL_MIN_ANN).forEach(ann -> {
                boolean exclusive = ann.booleanValue("inclusive").orElse(true) == false;
                BigDecimal min = ann.stringValue().map(BigDecimal::new).orElse(BigDecimal.ZERO);
                if (exclusive) {
                    schema.setExclusiveMinimum((Object)min);
                } else {
                    schema.setMinimum((Object)min);
                }
            });
            element.getAnnotationValuesByName(DECIMAL_MAX_ANN).forEach(ann -> {
                boolean exclusive = ann.booleanValue("inclusive").orElse(true) == false;
                BigDecimal max = ann.stringValue().map(BigDecimal::new).orElse(BigDecimal.ZERO);
                if (exclusive) {
                    schema.setExclusiveMaximum((Object)max);
                } else {
                    schema.setMaximum((Object)max);
                }
            });
            element.getAnnotationValuesByName(PATTERN_ANN).forEach(ann -> ann.stringValue("regexp").ifPresent(arg_0 -> ((Schema)schema).setPattern(arg_0)));
            if (element.hasAnnotation("jakarta.validation.constraints.Email$List")) {
                schema.setFormat("idn-email");
                element.getAnnotationValuesByName(EMAIL_ANN).forEach(ann -> ann.stringValue("regexp").ifPresent(arg_0 -> ((Schema)schema).setPattern(arg_0)));
            }
            element.getAnnotationValuesByName(DIGITS_ANN).forEach(ann -> {
                ann.intValue("integer").ifPresent(integer -> {
                    BigDecimal value = BigDecimal.valueOf(10L).pow(integer);
                    schema.setExclusiveMaximum((Object)value);
                    schema.setExclusiveMinimum((Object)value.negate());
                });
                ann.intValue("fraction").ifPresent(fraction -> {
                    if (fraction > 0) {
                        BigDecimal value = BigDecimal.ONE.divide(BigDecimal.TEN).pow(fraction);
                        schema.setMultipleOf((Object)value);
                    }
                });
            });
        }
        return schema;
    }

    static void addRequiredPropertyInfo(String propertyName, PropertyElement property, Schema schema, JsonSchemaContext context) {
        if (schema.getProperties() != null) {
            if (context.strictMode() && !property.hasAnnotation(NULLABLE_ANN)) {
                schema.addRequired(propertyName);
            } else if (property.isPrimitive() || property.hasAnnotation("jakarta.validation.constraints.NotNull$List") || property.hasAnnotation(NON_NULL_ANN)) {
                schema.addRequired(propertyName);
            }
        }
    }
}

