/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.visitor.context;

import io.micronaut.inject.ast.ClassElement;
import io.micronaut.jsonschema.model.Schema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public record JsonSchemaContext(String outputLocation, String baseUrl, boolean binaryAsArray, JsonSchemaDraft draft, boolean strictMode, Map<String, Schema> createdSchemasByType, List<ClassElement> currentOriginatingElements) {
    public static final String JSON_SCHEMA_CONTEXT_PROPERTY = "io.micronaut.jsonschema";
    public static final String PARAMETER_PREFIX = "micronaut.jsonschema.";
    public static final String OUTPUT_LOCATION_PARAMETER = "micronaut.jsonschema.outputLocation";
    public static final String BASE_URI_PARAMETER = "micronaut.jsonschema.baseUri";
    public static final String BINARY_AS_ARRAY_PARAMETER = "micronaut.jsonschema.binaryAsArray";
    public static final String JSON_SCHEMA_DRAFT_PARAMETER = "micronaut.jsonschema.draft";
    public static final String STRICT_MODE_PARAMETER = "micronaut.jsonschema.strictMode";
    public static final String DEFAULT_OUTPUT_LOCATION = "schemas";
    public static final boolean DEFAULT_BINARY_AS_ARRAY = false;
    private static final String DEFAULT_BASE_URL = "http://localhost:8080/schemas";
    private static final JsonSchemaDraft DEFAULT_DRAFT = JsonSchemaDraft.DRAFT_2020_12;
    private static final boolean DEFAULT_STRICT_MODE = false;

    public static Set<String> getParameters() {
        return Set.of(OUTPUT_LOCATION_PARAMETER, BASE_URI_PARAMETER, BINARY_AS_ARRAY_PARAMETER, JSON_SCHEMA_DRAFT_PARAMETER, STRICT_MODE_PARAMETER);
    }

    public static JsonSchemaContext createDefault(Map<String, String> options) {
        String outputLocation = options.getOrDefault(OUTPUT_LOCATION_PARAMETER, DEFAULT_OUTPUT_LOCATION);
        String baseUrl = options.getOrDefault(BASE_URI_PARAMETER, DEFAULT_BASE_URL);
        boolean binaryAsArray = options.getOrDefault(BINARY_AS_ARRAY_PARAMETER, String.valueOf(false)).equals("true");
        JsonSchemaDraft draft = options.get(JSON_SCHEMA_DRAFT_PARAMETER) == null ? DEFAULT_DRAFT : JsonSchemaDraft.valueOf(JSON_SCHEMA_DRAFT_PARAMETER);
        boolean strictMode = options.getOrDefault(STRICT_MODE_PARAMETER, String.valueOf(false)).equals("true");
        return new JsonSchemaContext(outputLocation, baseUrl, binaryAsArray, draft, strictMode, new HashMap<String, Schema>(), new ArrayList<ClassElement>());
    }

    public static enum JsonSchemaDraft {
        DRAFT_2020_12("https://json-schema.org/draft/2020-12/schema");

        private final String draftUrl;

        private JsonSchemaDraft(String draftUrl) {
            this.draftUrl = draftUrl;
        }

        public String getDraftUrl() {
            return this.draftUrl;
        }
    }
}

