/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.visitor;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.GeneratedFile;
import io.micronaut.jsonschema.JsonSchema;
import io.micronaut.jsonschema.model.Schema;
import io.micronaut.jsonschema.serialization.JsonSchemaMapperFactory;
import io.micronaut.jsonschema.visitor.NameUtils;
import io.micronaut.jsonschema.visitor.aggregator.DocumentationInfoAggregator;
import io.micronaut.jsonschema.visitor.aggregator.JacksonInfoAggregator;
import io.micronaut.jsonschema.visitor.aggregator.SchemaInfoAggregator;
import io.micronaut.jsonschema.visitor.aggregator.ValidationInfoAggregator;
import io.micronaut.jsonschema.visitor.context.JsonSchemaContext;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

@Internal
public final class JsonSchemaVisitor
implements TypeElementVisitor<JsonSchema, Object> {
    private static final List<SchemaInfoAggregator> SCHEMA_INFO_AGGREGATORS = List.of(new JacksonInfoAggregator(), new ValidationInfoAggregator(), new DocumentationInfoAggregator());
    private static final String SUFFIX = ".schema.json";
    private static final String SLASH = "/";

    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public Set<String> getSupportedOptions() {
        return JsonSchemaContext.getParameters();
    }

    public void visitClass(ClassElement element, VisitorContext visitorContext) {
        if (element.hasAnnotation(JsonSchema.class)) {
            JsonSchemaContext context = (JsonSchemaContext)visitorContext.get((CharSequence)"io.micronaut.jsonschema", JsonSchemaContext.class, null);
            if (context == null) {
                context = JsonSchemaContext.createDefault(visitorContext.getOptions());
                visitorContext.put((CharSequence)"io.micronaut.jsonschema", (Object)context);
            }
            context.currentOriginatingElements().clear();
            Schema schema = JsonSchemaVisitor.createTopLevelSchema((TypedElement)element, visitorContext, context);
            JsonSchemaVisitor.writeSchema(schema, element.getGenericType(), visitorContext, context);
        }
    }

    public static Schema createTopLevelSchema(TypedElement element, VisitorContext visitorContext, JsonSchemaContext context) {
        Schema schema = context.createdSchemasByType().get(element.getGenericType().getName());
        if (schema != null) {
            context.currentOriginatingElements().add(element.getGenericType());
            return schema;
        }
        schema = new Schema();
        AnnotationValue schemaAnn = element.getGenericType().getDeclaredAnnotation(JsonSchema.class);
        if (schemaAnn != null) {
            schema.setTitle(schemaAnn.stringValue("title").orElse(element.getGenericType().getSimpleName().replace('$', '.')));
            schemaAnn.stringValue("description").ifPresent(arg_0 -> ((Schema)schema).setDescription(arg_0));
            schema.set$id(JsonSchemaVisitor.createSchemaId(element, (AnnotationValue<JsonSchema>)schemaAnn, visitorContext, context));
            schema.set$schema(context.draft().getDraftUrl());
        }
        JsonSchemaVisitor.setSchemaType(element, visitorContext, context, schema);
        for (SchemaInfoAggregator aggregator : SCHEMA_INFO_AGGREGATORS) {
            schema = aggregator.addInfo(element, schema, visitorContext, context);
        }
        if (schemaAnn != null) {
            context.createdSchemasByType().put(element.getGenericType().getName(), schema);
        }
        return schema;
    }

    public static Schema createSchema(TypedElement element, VisitorContext visitorContext, JsonSchemaContext context) {
        if (!(element instanceof ClassElement) && element.hasAnnotation(JsonSchema.class)) {
            String ref = JsonSchemaVisitor.createSchemaId(element, (AnnotationValue<JsonSchema>)element.getAnnotation(JsonSchema.class), visitorContext, context);
            return Schema.reference((String)ref);
        }
        if (element.getGenericType().hasAnnotation(JsonSchema.class)) {
            String ref = context.createdSchemasByType().containsKey(element.getGenericType().getName()) ? context.createdSchemasByType().get(element.getGenericType().getName()).get$id() : JsonSchemaVisitor.createSchemaId(element, (AnnotationValue<JsonSchema>)element.getGenericType().getAnnotation(JsonSchema.class), visitorContext, context);
            context.currentOriginatingElements().add(element.getGenericType());
            return Schema.reference((String)ref);
        }
        return JsonSchemaVisitor.createTopLevelSchema(element, visitorContext, context);
    }

    private static String createSchemaId(TypedElement element, AnnotationValue<JsonSchema> schemaAnn, VisitorContext visitorContext, JsonSchemaContext context) {
        Object uri;
        String title = schemaAnn.stringValue("title").orElse(element.getGenericType().getSimpleName().replace('$', '.'));
        Optional uriOptional = schemaAnn.stringValue("uri");
        if (uriOptional.isPresent()) {
            uri = (String)uriOptional.get();
            if (!((String)uri).contains("://")) {
                uri = (String)uri + SUFFIX;
            }
        } else {
            uri = SLASH + NameUtils.camelCaseToKebabCase(title) + SUFFIX;
        }
        if (!((String)uri).contains("://")) {
            if (context.baseUrl() != null) {
                uri = context.baseUrl() + (String)uri;
            } else {
                visitorContext.warn("The JSON schema for type " + element.getName() + " does not have a resolvable URI", (Element)element);
            }
        }
        return uri;
    }

    private static void setSchemaType(TypedElement element, VisitorContext visitorContext, JsonSchemaContext context, Schema schema) {
        Object object;
        ClassElement type = element.getGenericType();
        if ((type.getName().equals("byte") || type.getName().equals("java.lang.Byte")) && type.isArray()) {
            schema.addType(Schema.Type.STRING);
        } else if (type.isAssignable(Map.class)) {
            ClassElement valueType = (ClassElement)type.getTypeArguments().get("V");
            if (valueType.getName().equals("java.lang.Object")) {
                schema.addType(Schema.Type.OBJECT);
            } else {
                schema.addType(Schema.Type.OBJECT).setAdditionalProperties(JsonSchemaVisitor.createSchema((TypedElement)valueType, visitorContext, context));
            }
        } else if (type.isAssignable(Collection.class)) {
            schema.addType(Schema.Type.ARRAY).setItems(JsonSchemaVisitor.createSchema((TypedElement)type.getTypeArguments().get("E"), visitorContext, context));
            if (type.isAssignable(Set.class)) {
                schema.setUniqueItems(true);
            }
        } else if (!type.isPrimitive() && (object = type.getRawClassElement()) instanceof EnumElement) {
            EnumElement enumElement = (EnumElement)object;
            schema.addType(Schema.Type.STRING).setEnumValues(enumElement.values().stream().map(v -> v).toList());
            context.currentOriginatingElements().add((ClassElement)enumElement);
        } else if (type.isAssignable(Number.class)) {
            switch (type.getName()) {
                case "java.lang.Integer": 
                case "java.lang.Long": 
                case "java.lang.Short": 
                case "java.lang.Byte": 
                case "java.math.BigInteger": {
                    schema.addType(Schema.Type.INTEGER);
                    break;
                }
                default: {
                    schema.addType(Schema.Type.NUMBER);
                    break;
                }
            }
        } else if (type.isAssignable(CharSequence.class)) {
            schema.addType(Schema.Type.STRING);
        } else if (type.isAssignable(Temporal.class)) {
            schema.addType(Schema.Type.STRING);
            switch (type.getName()) {
                case "java.time.OffsetTime": 
                case "java.time.LocalTime": {
                    schema.setFormat("time");
                    break;
                }
                case "java.time.LocalDate": 
                case "java.time.ChronoLocalDate": {
                    schema.setFormat("date");
                    break;
                }
                default: {
                    schema.setFormat("date-time");
                    break;
                }
            }
        } else if (type.isAssignable(TemporalAmount.class)) {
            schema.addType(Schema.Type.STRING).setFormat("duration");
        } else {
            switch (type.getName()) {
                case "boolean": 
                case "java.lang.Boolean": {
                    schema.addType(Schema.Type.BOOLEAN);
                    break;
                }
                case "int": 
                case "long": 
                case "short": 
                case "byte": 
                case "java.lang.Byte": {
                    schema.addType(Schema.Type.INTEGER);
                    break;
                }
                case "float": 
                case "double": {
                    schema.addType(Schema.Type.NUMBER);
                    break;
                }
                case "java.util.UUID": {
                    schema.addType(Schema.Type.STRING).setFormat("uuid");
                    break;
                }
                case "java.util.Date": 
                case "java.sql.Date": {
                    schema.addType(Schema.Type.STRING).setFormat("date-time");
                    break;
                }
                default: {
                    JsonSchemaVisitor.setBeanSchemaProperties(type, visitorContext, context, schema);
                }
            }
        }
    }

    public static void setBeanSchemaProperties(ClassElement element, VisitorContext visitorContext, JsonSchemaContext context, Schema schema) {
        schema.addType(Schema.Type.OBJECT);
        context.currentOriginatingElements().add(element);
        if (schema.getTitle() == null) {
            schema.setTitle(element.getSimpleName().replace('$', '.'));
        }
        if (context.strictMode()) {
            schema.setAdditionalProperties(Schema.FALSE);
        }
        context.createdSchemasByType().put(element.getGenericType().getName(), schema);
        for (PropertyElement property : element.getBeanProperties()) {
            Schema propertySchema = JsonSchemaVisitor.createSchema((TypedElement)property, visitorContext, context);
            schema.putProperty(property.getName(), propertySchema);
        }
    }

    public static void writeSchema(Schema schema, ClassElement originatingElement, VisitorContext visitorContext, JsonSchemaContext context) {
        String fileName = JsonSchemaVisitor.getFileName(schema, context);
        String path = context.outputLocation() + SLASH + fileName;
        GeneratedFile specFile = visitorContext.visitMetaInfFile(path, new Element[]{originatingElement}).orElse(null);
        if (specFile == null) {
            visitorContext.warn("Unable to get [\" " + path + "\"] file to write JSON schema", null);
        } else {
            visitorContext.info("Generating JSON schema file: " + specFile.getName());
            try (Writer writer = specFile.openWriter();){
                ObjectMapper mapper = JsonSchemaMapperFactory.createMapper();
                mapper.writeValue(writer, (Object)schema);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed writing JSON schema " + specFile.getName() + " file: " + e, e);
            }
        }
    }

    private static String getFileName(Schema schema, JsonSchemaContext context) {
        String id = schema.get$id();
        if (context.baseUrl() != null && id.startsWith(context.baseUrl())) {
            id = id.substring(context.baseUrl().length());
        } else if (id.contains("://") && (id = URI.create(id).getPath().substring(1)).startsWith(context.outputLocation())) {
            id = id.substring(context.outputLocation().length());
        }
        if (id.startsWith(SLASH)) {
            id = id.substring(1);
        }
        return id;
    }
}

