/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.utils;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.jsonschema.JsonSchema;
import io.micronaut.jsonschema.utils.JsonSchemaClassPathResourceLoader;
import io.micronaut.jsonschema.utils.JsonSchemaConfiguration;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Internal
class DefaultJsonSchemaClassPathResourceLoader
implements JsonSchemaClassPathResourceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJsonSchemaClassPathResourceLoader.class);
    private static final String SUFFIX = ".schema.json";
    private static final String MEMBER_URI = "uri";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String META_INF = "META-INF";
    private static final String SLASH = "/";
    private final ResourceLoader resourceLoader;
    private final JsonSchemaConfiguration jsonSchemaConfiguration;

    DefaultJsonSchemaClassPathResourceLoader(ResourceLoader resourceLoader, JsonSchemaConfiguration jsonSchemaConfiguration) {
        this.resourceLoader = resourceLoader;
        this.jsonSchemaConfiguration = jsonSchemaConfiguration;
    }

    @Override
    @Nullable
    public <T> Optional<String> jsonSchemaStringForClass(@NonNull Class<T> type) {
        Optional<String> optional;
        block13: {
            Optional<String> pathOptional = this.jsonSchemaPath(type);
            if (pathOptional.isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("No schema path found for type: {}", type);
                }
                return Optional.empty();
            }
            String path = pathOptional.get();
            Optional resourceAsStream = this.resourceLoader.getResourceAsStream(path);
            if (resourceAsStream.isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("No schema found for type: {} at path: {}", type, (Object)path);
                }
                return Optional.empty();
            }
            InputStream inputStream = (InputStream)resourceAsStream.get();
            try {
                optional = Optional.of(new String(inputStream.readAllBytes(), StandardCharsets.UTF_8));
                if (inputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error("Error loading schema", (Throwable)e);
                    }
                    return Optional.empty();
                }
            }
            inputStream.close();
        }
        return optional;
    }

    private <T> Optional<String> jsonSchemaPath(@NonNull Class<T> type) {
        String className = NameUtils.hyphenate((String)type.getSimpleName());
        try {
            BeanIntrospection introspection = BeanIntrospection.getIntrospection(type);
            AnnotationValue jsonSchemaAnnotationValue = introspection.getAnnotation(JsonSchema.class);
            if (jsonSchemaAnnotationValue == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("JsonSchema annotation not found for type: {}", type);
                }
                return Optional.empty();
            }
            Optional uriOptional = jsonSchemaAnnotationValue.stringValue(MEMBER_URI);
            if (uriOptional.isPresent()) {
                className = ((String)uriOptional.get()).replace(SLASH, "");
            }
        }
        catch (IntrospectionException e) {
            LOG.debug("Introspection exception for class {}.}", type, (Object)e);
        }
        String name = className + SUFFIX;
        return Optional.of(CLASSPATH_PREFIX + String.join((CharSequence)SLASH, META_INF, this.jsonSchemaConfiguration.getOutputLocation(), name));
    }
}

