/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.validation;

import com.networknt.schema.AbsoluteIri;
import com.networknt.schema.ExecutionContextCustomizer;
import com.networknt.schema.InputFormat;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.resource.InputStreamSource;
import com.networknt.schema.resource.SchemaLoader;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.json.JsonMapper;
import io.micronaut.jsonschema.utils.JsonSchemaClassPathResourceLoader;
import io.micronaut.jsonschema.utils.JsonSchemaConfiguration;
import io.micronaut.jsonschema.validation.JsonSchemaValidator;
import io.micronaut.jsonschema.validation.JsonSchemaValidatorConfiguration;
import io.micronaut.jsonschema.validation.ValidationMessage;
import io.micronaut.jsonschema.validation.ValidationMessageAdapter;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@Singleton
@Internal
final class DefaultJsonSchemaValidator
implements JsonSchemaValidator {
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final ExecutionContextCustomizer CONTEXT_CUSTOMIZER = (executionContext, validationContext) -> validationContext.getConfig().setFormatAssertionsEnabled(Boolean.valueOf(true));
    private static final String SLASH = "/";
    private static final String META_INF = "META-INF";
    private final Map<Class<?>, JsonSchema> jsonSchemaCache = new ConcurrentHashMap();
    private final JsonSchemaValidatorConfiguration config;
    private final ResourceLoader resourceLoader;
    private final JsonMapper jsonMapper;
    private final SchemaValidatorsConfig schemaValidatorsConfig;
    private final JsonSchemaClassPathResourceLoader jsonSchemaClassPathResourceLoader;
    private final JsonSchemaConfiguration jsonSchemaConfiguration;

    DefaultJsonSchemaValidator(JsonSchemaValidatorConfiguration config, ResourceLoader resourceLoader, JsonMapper jsonMapper, SchemaValidatorsConfig schemaValidatorsConfig, JsonSchemaClassPathResourceLoader jsonSchemaClassPathResourceLoader, JsonSchemaConfiguration jsonSchemaConfiguration) {
        this.config = config;
        this.resourceLoader = resourceLoader;
        this.jsonMapper = jsonMapper;
        this.schemaValidatorsConfig = schemaValidatorsConfig;
        this.jsonSchemaClassPathResourceLoader = jsonSchemaClassPathResourceLoader;
        this.jsonSchemaConfiguration = jsonSchemaConfiguration;
    }

    @Override
    public <T> Set<? extends ValidationMessage> validate(@NonNull String json, @NonNull Class<T> type) {
        JsonSchema schema = this.jsonSchemaCache.computeIfAbsent(type, this::jsonSchema);
        return DefaultJsonSchemaValidator.validate(schema, json);
    }

    @Override
    @NonNull
    public Set<? extends ValidationMessage> validate(@NonNull Object value, @NonNull Map<String, Object> jsonSchema) throws IOException {
        JsonSchema schema = this.jsonSchema(jsonSchema);
        return this.validate(schema, value);
    }

    @Override
    @NonNull
    public Set<? extends ValidationMessage> validate(@NonNull Object value, @NonNull String jsonSchema) throws IOException {
        JsonSchema schema = this.jsonSchema(jsonSchema);
        return this.validate(schema, value);
    }

    @Override
    @NonNull
    public <T> Set<? extends ValidationMessage> validate(@NonNull Object value, @NonNull Class<T> type) throws IOException {
        JsonSchema schema = this.jsonSchemaCache.computeIfAbsent(type, this::jsonSchema);
        return this.validate(schema, value);
    }

    private <T> JsonSchema jsonSchema(@NonNull Class<T> type) {
        String jsonSchema = this.jsonSchemaClassPathResourceLoader.jsonSchemaStringForClass(type).orElse(null);
        if (jsonSchema == null) {
            throw new IllegalArgumentException("No schema found for type: " + type);
        }
        return this.jsonSchema(jsonSchema);
    }

    @NonNull
    private JsonSchema jsonSchema(@NonNull Map<String, Object> jsonSchema) {
        try {
            String jsonSchemaString = this.jsonMapper.writeValueAsString(jsonSchema);
            return this.jsonSchema(jsonSchemaString);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not serialize JSON Schema from: " + jsonSchema);
        }
    }

    @NonNull
    private JsonSchema jsonSchema(@NonNull String jsonSchema) {
        JsonSchemaFactory jsonSchemaFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012, builder -> builder.schemaLoaders(b -> b.add((SchemaLoader)new ResourceSchemaLoader())));
        return jsonSchemaFactory.getSchema(jsonSchema, this.schemaValidatorsConfig);
    }

    private Set<? extends ValidationMessage> validate(JsonSchema schema, Object value) throws IOException {
        String s;
        String json = value instanceof String ? (s = (String)value) : this.jsonMapper.writeValueAsString(value);
        return DefaultJsonSchemaValidator.validate(schema, json);
    }

    private static Set<? extends ValidationMessage> validate(JsonSchema schema, String json) {
        return schema.validate(json, InputFormat.JSON, CONTEXT_CUSTOMIZER).stream().map(ValidationMessageAdapter::new).collect(Collectors.toSet());
    }

    private class ResourceSchemaLoader
    implements SchemaLoader {
        private ResourceSchemaLoader() {
        }

        public InputStreamSource getSchema(AbsoluteIri absoluteIri) {
            String classpathFolder;
            String filePath;
            String path = URI.create(absoluteIri.toString()).toString();
            if (path.startsWith(DefaultJsonSchemaValidator.this.config.baseUri())) {
                path = path.substring(DefaultJsonSchemaValidator.this.config.baseUri().length());
            }
            if (!(filePath = Path.of((classpathFolder = "META-INF/" + DefaultJsonSchemaValidator.this.jsonSchemaConfiguration.getOutputLocation() + DefaultJsonSchemaValidator.SLASH) + path, new String[0]).normalize().toString()).startsWith(classpathFolder)) {
                throw new IllegalArgumentException("Schema for URI " + absoluteIri + " is not inside the required folder " + DefaultJsonSchemaValidator.this.config.classpathFolder() + " at path: " + path);
            }
            return () -> (InputStream)DefaultJsonSchemaValidator.this.resourceLoader.getResourceAsStream(DefaultJsonSchemaValidator.CLASSPATH_PREFIX + filePath).orElseThrow(() -> new IllegalArgumentException("No schema found for uri: " + absoluteIri + " at path: " + filePath));
        }
    }
}

