/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.streams;

import io.micronaut.configuration.kafka.config.KafkaDefaultConfiguration;
import io.micronaut.configuration.kafka.streams.AbstractKafkaStreamsConfiguration;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.runtime.ApplicationConfiguration;
import java.util.Map;
import java.util.Properties;

@EachProperty(value="kafka.streams", primary="default")
@Requires(beans={KafkaDefaultConfiguration.class})
public class KafkaStreamsConfiguration<K, V>
extends AbstractKafkaStreamsConfiguration<K, V> {
    public static final String PREFIX = "kafka.streams";

    public KafkaStreamsConfiguration(@Parameter String streamName, KafkaDefaultConfiguration defaultConfiguration, ApplicationConfiguration applicationConfiguration, Environment environment) {
        super(defaultConfiguration);
        Properties config = this.getConfig();
        String propertyKey = "kafka.streams." + NameUtils.hyphenate((String)streamName, (boolean)true);
        config.putAll((Map<?, ?>)environment.getProperty(propertyKey, Properties.class).orElseGet(Properties::new));
        this.init(applicationConfiguration, environment, config);
    }
}

