/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.streams;

import io.micronaut.configuration.kafka.config.AbstractKafkaConfiguration;
import io.micronaut.configuration.kafka.config.KafkaDefaultConfiguration;
import io.micronaut.context.env.Environment;
import io.micronaut.core.util.StringUtils;
import io.micronaut.runtime.ApplicationConfiguration;
import java.io.File;
import java.util.Map;
import java.util.Properties;

public class AbstractKafkaStreamsConfiguration<K, V>
extends AbstractKafkaConfiguration<K, V> {
    protected AbstractKafkaStreamsConfiguration(KafkaDefaultConfiguration defaultConfiguration) {
        super(new Properties());
        Properties config = this.getConfig();
        config.putAll((Map<?, ?>)defaultConfiguration.getConfig());
    }

    protected void init(ApplicationConfiguration applicationConfiguration, Environment environment, Properties config) {
        String tmpDir;
        String applicationName = applicationConfiguration.getName().orElse("application");
        config.putIfAbsent("application.id", applicationName);
        if (environment.getActiveNames().contains("test") && StringUtils.isNotEmpty((CharSequence)(tmpDir = System.getProperty("java.io.tmpdir"))) && new File(tmpDir, applicationName).mkdirs()) {
            config.putIfAbsent("state.dir", tmpDir);
        }
    }
}

