/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.streams;

import java.util.Collection;
import java.util.Optional;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.QueryableStoreType;

public class InteractiveQueryService {
    private final Collection<KafkaStreams> streams;

    InteractiveQueryService(Collection<KafkaStreams> streams) {
        this.streams = streams;
    }

    public <T> Optional<T> getQueryableStore(String storeName, QueryableStoreType<T> storeType) {
        for (KafkaStreams kafkaStream : this.streams) {
            try {
                Object store = kafkaStream.store(StoreQueryParameters.fromNameAndType((String)storeName, storeType));
                if (store == null) continue;
                return Optional.of(store);
            }
            catch (InvalidStateStoreException invalidStateStoreException) {
            }
        }
        return Optional.empty();
    }
}

