/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.streams;

import io.micronaut.configuration.kafka.config.AbstractKafkaConfiguration;
import io.micronaut.configuration.kafka.config.KafkaDefaultConfiguration;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.naming.Named;
import io.micronaut.core.util.StringUtils;
import io.micronaut.runtime.ApplicationConfiguration;
import java.io.File;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;

public class AbstractKafkaStreamsConfiguration<K, V>
extends AbstractKafkaConfiguration<K, V>
implements Named {
    public static final String DEFAULT_NAME = "default";
    public static final Duration DEFAULT_CLOSE_TIMEOUT = Duration.ofSeconds(3L);
    private String name = "default";
    private Duration closeTimeout = DEFAULT_CLOSE_TIMEOUT;

    protected AbstractKafkaStreamsConfiguration(KafkaDefaultConfiguration defaultConfiguration) {
        super(new Properties());
        Properties config = this.getConfig();
        config.putAll((Map<?, ?>)defaultConfiguration.getConfig());
    }

    protected void init(ApplicationConfiguration applicationConfiguration, Environment environment, Properties config) {
        String tmpDir;
        String applicationName = applicationConfiguration.getName().orElse("application");
        config.putIfAbsent("application.id", applicationName);
        if (environment.getActiveNames().contains("test") && StringUtils.isNotEmpty((CharSequence)(tmpDir = System.getProperty("java.io.tmpdir"))) && new File(tmpDir, applicationName).mkdirs()) {
            config.putIfAbsent("state.dir", tmpDir);
        }
    }

    public Duration getCloseTimeout() {
        return this.closeTimeout;
    }

    public void setCloseTimeout(Duration closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

