/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka.streams.health.serde;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serde;
import io.micronaut.serde.Serializer;
import jakarta.inject.Singleton;
import java.io.IOException;
import org.apache.kafka.streams.processor.TaskId;

@Singleton
public final class TaskIdSerde
implements Serde<TaskId> {
    @Nullable
    public TaskId deserialize(@NonNull Decoder decoder, Deserializer.DecoderContext context, @NonNull Argument<? super TaskId> type) throws IOException {
        String taskIdStr = decoder.decodeString();
        return TaskId.parse((String)taskIdStr);
    }

    public void serialize(@NonNull Encoder encoder, Serializer.EncoderContext context, @NonNull Argument<? extends TaskId> type, @NonNull TaskId value) throws IOException {
        encoder.encodeString(value.toString());
    }
}

