/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.kafka;

import io.micronaut.configuration.kafka.config.AbstractKafkaConsumerConfiguration;
import io.micronaut.configuration.kafka.serde.JsonSerde;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.TypeHint;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.RangeAssignor;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.clients.consumer.StickyAssignor;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.ByteBufferDeserializer;
import org.apache.kafka.common.serialization.ByteBufferSerializer;
import org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.kafka.common.serialization.BytesSerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.DoubleDeserializer;
import org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.kafka.common.serialization.FloatDeserializer;
import org.apache.kafka.common.serialization.FloatSerializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.ShortDeserializer;
import org.apache.kafka.common.serialization.ShortSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;

@Factory
@TypeHint(value={ShortSerializer.class, DoubleSerializer.class, LongSerializer.class, BytesSerializer.class, ByteArraySerializer.class, IntegerSerializer.class, ByteBufferSerializer.class, StringSerializer.class, FloatSerializer.class, JsonSerde.class, ShortDeserializer.class, DoubleDeserializer.class, LongDeserializer.class, BytesDeserializer.class, ByteArrayDeserializer.class, IntegerDeserializer.class, ByteBufferDeserializer.class, StringDeserializer.class, FloatDeserializer.class, DefaultPartitioner.class, RangeAssignor.class, RoundRobinAssignor.class, StickyAssignor.class})
public class KafkaConsumerFactory {
    @Prototype
    public <K, V> KafkaConsumer<K, V> createConsumer(@Parameter AbstractKafkaConsumerConfiguration<K, V> consumerConfiguration) {
        Optional<Deserializer<K>> keyDeserializer = consumerConfiguration.getKeyDeserializer();
        Optional<Deserializer<V>> valueDeserializer = consumerConfiguration.getValueDeserializer();
        Properties config = consumerConfiguration.getConfig();
        if (keyDeserializer.isPresent() && valueDeserializer.isPresent()) {
            return new KafkaConsumer(config, keyDeserializer.get(), valueDeserializer.get());
        }
        if (keyDeserializer.isPresent() || valueDeserializer.isPresent()) {
            throw new ConfigurationException("Both the [keyDeserializer] and [valueDeserializer] must be set when setting either");
        }
        return new KafkaConsumer(config);
    }
}

